/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.api.processor;

import com.sdl.odata.api.processor.query.QueryResult;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.api.service.ODataResponse;
import java.util.HashMap;
import java.util.Map;

public final class ProcessorResult {
    private final ODataResponse.Status status;
    private final QueryResult queryResult;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final ODataRequestContext requestContext;

    public ProcessorResult(ODataResponse.Status status) {
        this.status = status;
        this.queryResult = null;
        this.requestContext = null;
    }

    public ProcessorResult(ODataResponse.Status status, Map<String, String> headers) {
        this.status = status;
        this.queryResult = null;
        this.headers.putAll(headers);
        this.requestContext = null;
    }

    public ProcessorResult(ODataResponse.Status status, QueryResult queryResult) {
        this.status = status;
        this.queryResult = queryResult;
        this.requestContext = null;
    }

    public ProcessorResult(ODataResponse.Status status, QueryResult queryResult, Map<String, String> headers) {
        this.status = status;
        this.queryResult = queryResult;
        this.headers.putAll(headers);
        this.requestContext = null;
    }

    public ProcessorResult(ODataResponse.Status status, QueryResult queryResult, Map<String, String> headers, ODataRequestContext requestContext) {
        this.status = status;
        this.queryResult = queryResult;
        this.headers.putAll(headers);
        this.requestContext = requestContext;
    }

    public ODataResponse.Status getStatus() {
        return this.status;
    }

    public QueryResult getQueryResult() {
        return this.queryResult;
    }

    public Object getData() {
        return this.queryResult != null ? this.queryResult.getData() : null;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public ODataRequestContext getRequestContext() {
        return this.requestContext;
    }

    public String toString() {
        return "ProcessorResult { status=" + (Object)((Object)this.status) + ", queryResult=" + this.queryResult + ", headers=" + this.headers + " }";
    }
}

