/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.api.service;

import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.api.service.ODataRequestResponseBase;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ODataResponse
extends ODataRequestResponseBase {
    private final Status status;

    private ODataResponse(Builder builder) {
        super(Collections.unmodifiableMap(builder.headersMap), builder.body);
        if (builder.status == null) {
            throw new IllegalArgumentException("Status is required");
        }
        this.status = builder.status;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        return this.status.toString();
    }

    public static class Builder {
        private Status status;
        private final Map<String, String> headersMap = new HashMap<String, String>();
        private byte[] body;

        public Builder setStatus(Status builderStatus) {
            this.status = builderStatus;
            return this;
        }

        public Builder setHeader(String name, String value) {
            this.headersMap.put(name, value);
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headersMap.putAll(headers);
            return this;
        }

        public Builder setContentType(MediaType contentType) {
            this.headersMap.put("Content-Type", contentType.toString());
            return this;
        }

        public Builder setBody(byte[] builderBody) {
            this.body = builderBody;
            return this;
        }

        public Builder setBodyText(String bodyText, String charset) throws UnsupportedEncodingException {
            this.body = bodyText.getBytes(charset);
            return this;
        }

        public ODataResponse build() {
            return new ODataResponse(this);
        }
    }

    public static enum Status {
        OK(200),
        CREATED(201),
        ACCEPTED(202),
        NO_CONTENT(204),
        NOT_MODIFIED(304),
        BAD_REQUEST(400),
        UNAUTHORIZED(401),
        FORBIDDEN(403),
        NOT_FOUND(404),
        METHOD_NOT_ALLOWED(405),
        NOT_ACCEPTABLE(406),
        GONE(410),
        REQUEST_ENTITY_TOO_LARGE(413),
        UNSUPPORTED_MEDIA_TYPE(415),
        INTERNAL_SERVER_ERROR(500),
        NOT_IMPLEMENTED(501),
        SERVICE_UNAVAILABLE(503);

        private final int code;

        private Status(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static Status forCode(int code) {
            for (Status status : Status.values()) {
                if (status.code != code) continue;
                return status;
            }
            throw new IllegalArgumentException("Invalid status code: " + code);
        }

        public String toString() {
            return this.code + " " + this.name();
        }
    }
}

