/**
 * Copyright (c) 2014-2024 All Rights Reserved by the RWS Group for and on behalf of its affiliates and subsidiaries.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.sdl.odata.api.edm.model;

import java.util.List;

/**
 * OData entity set.
 *
 * Reference: OData Version 4.0 Part 3: Common Schema Definition Language (CSDL), paragraph 13.2
 *
 */
public interface EntitySet {

    /**
     * Returns the name of the entity set.
     *
     * @return The name of the entity set.
     */
    String getName();

    /**
     * Returns the fully-qualified name of the entity type of the entities in this entity set.
     *
     * @return The fully-qualified name of the entity type of the entities in this entity set.
     */
    String getTypeName();

    /**
     * Returns {@code true} if this entity set should be included in the service document, {@code false} otherwise.
     *
     * @return {@code true} if this entity set should be included in the service document, {@code false} otherwise.
     */
    boolean isIncludedInServiceDocument();

    /**
     * Returns the navigation property bindings in this entity set.
     *
     * @return The navigation property bindings in this entity set.
     */
    List<NavigationPropertyBinding> getNavigationPropertyBindings();
}
