/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.controller;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.service.ODataRequest;
import com.sdl.odata.api.service.ODataResponse;
import com.sdl.odata.api.service.ODataService;
import com.sdl.odata.util.ReferenceUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class AbstractODataController {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractODataController.class);
    private static final int BUFFER_SIZE = 1024;
    private static final int DEFAULT_PORT_NUMBER = 80;
    private static final int DEFAULT_SSL_PORT_NUMBER = 443;
    @Autowired
    private ODataService oDataService;

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PATCH, RequestMethod.PUT, RequestMethod.DELETE})
    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        ODataResponse oDataResponse;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Start processing request from: {}", (Object)servletRequest.getRemoteAddr());
        }
        try {
            ODataRequest oDataRequest = this.buildODataRequest(servletRequest);
            this.doWireLogging(oDataRequest);
            oDataResponse = this.oDataService.handleRequest(oDataRequest);
        }
        catch (ODataException e) {
            throw new ServletException((Throwable)e);
        }
        this.fillServletResponse(oDataResponse, servletResponse);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Finished processing request from: {}", (Object)servletRequest.getRemoteAddr());
        }
    }

    private ODataRequest buildODataRequest(HttpServletRequest servletRequest) throws IOException {
        int count;
        ODataRequest.Builder builder = new ODataRequest.Builder();
        builder.setMethod(ODataRequest.Method.valueOf((String)servletRequest.getMethod()));
        StringBuilder sb = this.getRequestURL(servletRequest);
        String queryString = servletRequest.getQueryString();
        if (!ReferenceUtil.isNullOrEmpty((String)queryString)) {
            sb.append('?').append(queryString);
        }
        builder.setUri(sb.toString());
        Enumeration e = servletRequest.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = servletRequest.getHeader(name);
            builder.setHeader(name, value);
        }
        ServletInputStream in = servletRequest.getInputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
        builder.setBody(out.toByteArray());
        return builder.build();
    }

    private StringBuilder getRequestURL(HttpServletRequest request) {
        String scheme = request.getScheme();
        int port = request.getServerPort();
        if (port < 0) {
            port = 80;
        }
        StringBuilder url = new StringBuilder();
        url.append(scheme);
        url.append("://");
        url.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(request.getRequestURI());
        return url;
    }

    private void fillServletResponse(ODataResponse oDataResponse, HttpServletResponse servletResponse) throws IOException {
        servletResponse.setStatus(oDataResponse.getStatus().getCode());
        for (Map.Entry entry : oDataResponse.getHeaders().entrySet()) {
            servletResponse.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        byte[] body = oDataResponse.getBody();
        if (body != null && body.length != 0) {
            ServletOutputStream out = servletResponse.getOutputStream();
            out.write(oDataResponse.getBody());
            out.flush();
        }
    }

    private void doWireLogging(ODataRequest request) throws UnsupportedEncodingException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("RAW REQUEST LOGGING");
            LOG.trace("{} request for URL: {}", (Object)request.getMethod().name(), (Object)request.getUri());
            for (Map.Entry headerEntry : request.getHeaders().entrySet()) {
                LOG.trace("Header: {} value: {}", headerEntry.getKey(), headerEntry.getValue());
            }
            LOG.trace("BODY: {}", (Object)request.getBodyText(StandardCharsets.UTF_8.name()));
        }
    }
}

