/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.service;

import com.sdl.odata.edm.EdmConfiguration;
import com.sdl.odata.parser.ParserConfiguration;
import com.sdl.odata.processor.ProcessorConfiguration;
import com.sdl.odata.renderer.RendererConfiguration;
import com.sdl.odata.service.actor.ODataBatchProcessorActor;
import com.sdl.odata.service.actor.ODataBatchRendererActor;
import com.sdl.odata.service.actor.ODataParserActor;
import com.sdl.odata.service.actor.ODataQueryProcessorActor;
import com.sdl.odata.service.actor.ODataRendererActor;
import com.sdl.odata.service.actor.ODataRequestProcessorActor;
import com.sdl.odata.service.actor.ODataUnmarshallerActor;
import com.sdl.odata.service.actor.ODataWriteProcessorActor;
import com.sdl.odata.service.protocol.BatchOperation;
import com.sdl.odata.service.protocol.BatchOperationResult;
import com.sdl.odata.service.protocol.ErrorMessage;
import com.sdl.odata.service.protocol.OperationResult;
import com.sdl.odata.service.protocol.ParseResult;
import com.sdl.odata.service.protocol.ReadOperation;
import com.sdl.odata.service.protocol.Render;
import com.sdl.odata.service.protocol.ServiceRequest;
import com.sdl.odata.service.protocol.Unmarshall;
import com.sdl.odata.service.protocol.UnmarshallResult;
import com.sdl.odata.service.protocol.WriteOperation;
import com.sdl.odata.service.spring.ActorProducer;
import com.sdl.odata.service.util.AkkaUtil;
import com.sdl.odata.unmarshaller.UnmarshallerConfiguration;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;

@Configuration
@ComponentScan(value={"com.sdl.odata.service"})
@Import(value={EdmConfiguration.class, ParserConfiguration.class, ProcessorConfiguration.class, RendererConfiguration.class, UnmarshallerConfiguration.class})
@ImportResource(value={"classpath*:/META-INF/*/odata-*.xml"})
public class ODataServiceConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ODataServiceConfiguration.class);
    @Autowired
    private ActorProducer actorProducer;

    @PostConstruct
    public void intializeService() {
        LOG.info("Initializing OData service routing");
        AkkaUtil.registerRoute(ServiceRequest.class, ODataParserActor.class, this.actorProducer);
        AkkaUtil.registerRoute(Unmarshall.class, ODataUnmarshallerActor.class, this.actorProducer);
        AkkaUtil.registerRoute(ParseResult.class, ODataRequestProcessorActor.class, this.actorProducer);
        AkkaUtil.registerRoute(UnmarshallResult.class, ODataRequestProcessorActor.class, this.actorProducer);
        AkkaUtil.registerRoute(ReadOperation.class, ODataQueryProcessorActor.class, this.actorProducer);
        AkkaUtil.registerRoute(WriteOperation.class, ODataWriteProcessorActor.class, this.actorProducer);
        AkkaUtil.registerRoute(BatchOperation.class, ODataBatchProcessorActor.class, this.actorProducer);
        AkkaUtil.registerRoute(OperationResult.class, ODataRequestProcessorActor.class, this.actorProducer);
        AkkaUtil.registerRoute(Render.class, ODataRendererActor.class, this.actorProducer);
        AkkaUtil.registerRoute(BatchOperationResult.class, ODataBatchRendererActor.class, this.actorProducer);
        AkkaUtil.registerRoute(ErrorMessage.class, ODataRendererActor.class, this.actorProducer);
    }
}

