/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.odata.service.spring;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import com.sdl.odata.service.spring.AkkaSpringExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActorProducer {
    @Autowired
    private AkkaSpringExtension akkaSpringExtension;
    @Autowired
    private ActorSystem actorSystem;

    public void tell(String actorId, Object message) {
        Props props = this.create(actorId);
        this.actorSystem.actorOf(props).tell(message, null);
    }

    public void tell(String actorId, Object message, ActorRef self) {
        this.actorRef(actorId).tell(message, self);
    }

    public void tell(String actorId, Object message, ActorRef self, ActorContext context) {
        this.actorRef(actorId, context).tell(message, self);
    }

    public ActorRef actorRef(String actorId) {
        return this.actorSystem.actorOf(this.create(actorId));
    }

    public ActorRef actorRef(String actorId, ActorContext context) {
        return context.actorOf(this.create(actorId));
    }

    public Props create(String actorId) {
        return ((AkkaSpringExtension.AkkaExtension)this.akkaSpringExtension.get(this.actorSystem)).props(actorId);
    }
}

