/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.context.odata.client;

import com.sdl.web.client.configuration.ConfigurationPath;
import com.sdl.web.client.configuration.XMLConfigurationReaderImpl;
import com.sdl.web.client.configuration.api.ConfigurationException;
import com.sdl.web.client.configuration.api.ConfigurationHolder;
import com.sdl.web.client.impl.CapabilityProviderFactory;
import com.sdl.web.discovery.datalayer.model.ContextServiceCapability;
import com.sdl.web.discovery.util.CommonUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextServiceClientConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ContextServiceClientConfiguration.class);
    private static final String CLIENT_CONFIGURATION_FILE_NAME = "cd_client_conf.xml";
    private String discoveryServiceUri;
    private Properties clientConfigurationProperties;

    public Properties readClientConfiguration() throws ConfigurationException {
        XMLConfigurationReaderImpl configurationReader = new XMLConfigurationReaderImpl();
        ConfigurationHolder configurationHolder = configurationReader.readConfiguration(CLIENT_CONFIGURATION_FILE_NAME);
        Optional<Object> contextServiceUri = Optional.empty();
        try {
            contextServiceUri = Optional.of(this.resolveContextServiceUriUsingDiscoveryService(configurationHolder));
        }
        catch (Exception ex) {
            LOG.warn("Unable to resolve ContextService uri using discovery service. Proceeding with fallback variant.", (Throwable)ex);
        }
        if (!contextServiceUri.isPresent()) {
            try {
                contextServiceUri = Optional.of(configurationHolder.getConfiguration(new ConfigurationPath("/ContextService")).getValue("ServiceUri"));
                LOG.info("Successfully resolved ContextService uri: {} using fallback variant", contextServiceUri.get());
            }
            catch (ConfigurationException ex) {
                throw new ConfigurationException("Could not resolve ContextService Uri", (Throwable)ex);
            }
        }
        LOG.info("Context service configured " + (String)contextServiceUri.get());
        Map commonConfiguration = configurationHolder.getValues();
        commonConfiguration.put("ServiceUri", contextServiceUri.get());
        this.clientConfigurationProperties.put("ServiceUri", contextServiceUri.get());
        return CommonUtils.mapsToPropertiesConverted((Map[])new Map[]{commonConfiguration});
    }

    protected String resolveContextServiceUriUsingDiscoveryService(ConfigurationHolder configurationHolder) throws ConfigurationException {
        Map commonConfiguration = configurationHolder.getValues();
        Map discoveryServiceConfiguration = configurationHolder.getConfiguration(new ConfigurationPath("/DiscoveryService")).getValues();
        Map tokenServiceConfiguration = new HashMap();
        try {
            tokenServiceConfiguration = configurationHolder.getConfiguration(new ConfigurationPath("/TokenService")).getValues();
        }
        catch (ConfigurationException ce) {
            LOG.warn("TokenService properties are not configured for client.");
        }
        this.clientConfigurationProperties = CommonUtils.mapsToPropertiesConverted((Map[])new Map[]{commonConfiguration, discoveryServiceConfiguration, tokenServiceConfiguration});
        this.discoveryServiceUri = (String)discoveryServiceConfiguration.get("ServiceUri");
        LOG.info("Discovery service configured " + this.discoveryServiceUri);
        Optional capability = (tokenServiceConfiguration.isEmpty() ? CapabilityProviderFactory.getCachingDefaultCapabilityProvider((Properties)this.clientConfigurationProperties) : CapabilityProviderFactory.getCachingSecuredCapabilityProvider((Properties)this.clientConfigurationProperties)).getCapability(ContextServiceCapability.class);
        ContextServiceCapability csc = (ContextServiceCapability)capability.orElseThrow(() -> new ConfigurationException("ContextServiceCapability not defined!"));
        LOG.info("Resolved ContextService capability: {} using discovery service.", (Object)csc);
        return csc.getUri();
    }

    public String getDiscoveryServiceUri() {
        return this.discoveryServiceUri;
    }

    public Properties getClientConfigurations() {
        return this.clientConfigurationProperties;
    }
}

