/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.context.odata.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.sdl.context.api.Aspect;
import com.sdl.context.api.ContextMap;
import com.sdl.context.api.ContextVocabulary;
import com.sdl.context.api.definition.ContextPropertyType;
import com.sdl.context.api.engine.ContextEngine;
import com.sdl.context.api.exception.ResolverException;
import com.sdl.context.api.resolution.Evidence;
import com.sdl.context.odata.ContextODataServiceEntitiesProvider;
import com.sdl.context.odata.client.ContextServiceClientConfiguration;
import com.sdl.context.odata.model.ODataContextMap;
import com.sdl.context.odata.model.ODataContextVocabulary;
import com.sdl.context.odata.model.adapter.ODataContextMapAdapter;
import com.sdl.context.odata.model.adapter.ODataContextVocabularyAdapter;
import com.sdl.context.odata.serialization.EvidenceSerializer;
import com.sdl.odata.client.BasicODataClientQuery;
import com.sdl.odata.client.FunctionImportClientQuery;
import com.sdl.odata.client.ODataClientFactoryImpl;
import com.sdl.odata.client.ODataV4ClientComponentsProvider;
import com.sdl.odata.client.URLConnectionRequestPropertiesBuilder;
import com.sdl.odata.client.api.ODataClient;
import com.sdl.odata.client.api.ODataClientComponentsProvider;
import com.sdl.odata.client.api.ODataClientQuery;
import com.sdl.odata.client.api.exception.ODataClientException;
import com.sdl.odata.client.api.exception.ODataClientRuntimeException;
import com.sdl.web.client.configuration.api.ConfigurationException;
import com.sdl.web.client.impl.OAuthTokenProvider;
import com.sdl.web.client.versions.ContentVersionManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataContextEngineProxy
implements ContextEngine {
    private static final Logger LOG = LoggerFactory.getLogger(ODataContextEngineProxy.class);
    private static final int ATTEMPT_DELAY_FACTOR = 100;
    private static final int MAX_RETRY_COUNT = 3;
    private static final String EVALUATE_EXPRESSION_FUNCTION = "EvaluateExpressionFunctionImport";
    private static final EvidenceSerializer EVIDENCE_SERIALIZER = new EvidenceSerializer();
    private OAuthTokenProvider tokenProvider;
    private ODataClient oDataClient;
    private ContentVersionManager versionManager;

    public ODataContextEngineProxy(ContextServiceClientConfiguration configuration) throws ConfigurationException {
        Properties oauthProperties = new Properties();
        oauthProperties.putAll((Map<?, ?>)configuration.getClientConfigurations());
        oauthProperties.put("ServiceUri", configuration.getDiscoveryServiceUri());
        try {
            this.tokenProvider = new OAuthTokenProvider(oauthProperties);
        }
        catch (Exception e) {
            LOG.info("Error Initializing Token Provider.", (Throwable)e);
        }
        ODataClientFactoryImpl clientFactory = new ODataClientFactoryImpl();
        List entityClasses = ContextODataServiceEntitiesProvider.getODataServiceEntities().stream().map(Class::getName).collect(Collectors.toList());
        ODataV4ClientComponentsProvider provider = new ODataV4ClientComponentsProvider(entityClasses, configuration.getClientConfigurations());
        this.oDataClient = clientFactory.create((ODataClientComponentsProvider)provider);
        this.oDataClient.encodeURL(false);
        this.versionManager = new ContentVersionManager(provider.getWebServiceUrl().toString(), this.buildRequestProperties());
    }

    public ContextMap<? extends Aspect> resolve(Evidence evidence) throws ResolverException {
        BasicODataClientQuery oDataClientQuery;
        String serializedEvidence;
        this.checkVersion();
        try {
            serializedEvidence = this.getSerializedEvidence(evidence);
        }
        catch (ODataClientException e) {
            throw new ResolverException("Unable serialize evidence argument", (Throwable)e);
        }
        try {
            oDataClientQuery = new BasicODataClientQuery.Builder().withEntityType(ODataContextMap.class).withEntityKey(String.format("'%s'", URLEncoder.encode(serializedEvidence, "UTF-8"))).build();
        }
        catch (UnsupportedEncodingException e) {
            throw new ResolverException("Unable to encode serialized evidence", (Throwable)e);
        }
        ODataContextMap result = null;
        for (int attempt = 1; attempt <= 3; ++attempt) {
            try {
                result = (ODataContextMap)this.oDataClient.getEntity(this.buildRequestProperties(), (ODataClientQuery)oDataClientQuery);
                continue;
            }
            catch (ODataClientRuntimeException e) {
                if (!this.retryIfNecessary(e)) {
                    throw e;
                }
                if (attempt != 3) {
                    this.sleep(attempt);
                    continue;
                }
                LOG.debug("Retry limit exceeded.");
                throw e;
            }
        }
        return new ODataContextMapAdapter(result);
    }

    public ContextVocabulary getVocabulary() {
        this.checkVersion();
        BasicODataClientQuery oDataClientQuery = new BasicODataClientQuery.Builder().withEntityType(ODataContextVocabulary.class).build();
        List vocabularies = null;
        for (int attempt = 1; attempt <= 3; ++attempt) {
            try {
                vocabularies = this.oDataClient.getEntities(this.buildRequestProperties(), (ODataClientQuery)oDataClientQuery);
                continue;
            }
            catch (ODataClientRuntimeException e) {
                if (!this.retryIfNecessary(e)) {
                    throw e;
                }
                if (attempt != 3) {
                    this.sleep(attempt);
                    continue;
                }
                LOG.debug("Retry limit exceeded.");
                throw e;
            }
        }
        if (vocabularies == null || vocabularies.isEmpty()) {
            throw new ODataClientRuntimeException("Response returned from endpoint doesn't contain a vocabulary");
        }
        return new ODataContextVocabularyAdapter((ODataContextVocabulary)vocabularies.get(0));
    }

    public Object evaluateExpression(String expression, ContextPropertyType type) {
        if (expression == null || type == null) {
            throw new ODataClientRuntimeException("Expression or Type cannot be null");
        }
        this.checkVersion();
        ODataClientQuery query = new FunctionImportClientQuery.Builder().withEntityType(String.class).withFunctionName(EVALUATE_EXPRESSION_FUNCTION).withFunctionParameter("Expression", this.encloseWithinQuotesDoubleEncoded(expression)).withFunctionParameter("Type", this.encloseWithinQuotes(type.name())).build();
        Object entity = null;
        for (int attempt = 1; attempt <= 3; ++attempt) {
            try {
                entity = this.oDataClient.getEntity(this.buildRequestProperties(), query);
                continue;
            }
            catch (ODataClientRuntimeException e) {
                if (!this.retryIfNecessary(e)) {
                    throw e;
                }
                if (attempt != 3) {
                    this.sleep(attempt);
                    continue;
                }
                LOG.debug("Retry limit exceeded.");
                throw e;
            }
        }
        return entity;
    }

    private String encloseWithinQuotesDoubleEncoded(String expression) {
        try {
            return this.encloseWithinQuotes(URLEncoder.encode(URLEncoder.encode(expression, StandardCharsets.UTF_8.name()), StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new ODataClientRuntimeException("Error encoding expression.", (Throwable)e);
        }
    }

    private String encloseWithinQuotes(String value) {
        return "'" + value + "'";
    }

    private void checkVersion() {
        if (!this.versionManager.isCompatible()) {
            LOG.debug("CIL doesn't support CIS {}", (Object)this.versionManager.getServiceVersion());
            throw new ODataClientRuntimeException("Unsupported version: " + this.versionManager.getServiceVersion());
        }
    }

    private String getSerializedEvidence(Evidence evidence) throws ODataClientException {
        try {
            return EVIDENCE_SERIALIZER.serialize(evidence);
        }
        catch (JsonProcessingException | RuntimeException e) {
            throw new ODataClientException("Caught exception " + e.getClass().getSimpleName() + ":" + e.getMessage() + " when serialising evidence into json format", e);
        }
    }

    private Map<String, String> buildRequestProperties() {
        URLConnectionRequestPropertiesBuilder urlPropsBuilder = new URLConnectionRequestPropertiesBuilder();
        if (this.tokenProvider != null) {
            urlPropsBuilder.withAccessToken(this.tokenProvider.getToken());
        }
        return urlPropsBuilder.build();
    }

    private boolean retryIfNecessary(ODataClientRuntimeException e) {
        Throwable originalCause;
        Throwable cause = e.getCause();
        if (cause != null && cause instanceof ODataClientException && (originalCause = cause.getCause()) != null && originalCause instanceof IOException) {
            LOG.debug("Request failed, retrying.", (Throwable)e);
            return true;
        }
        return false;
    }

    private void sleep(int attempt) {
        try {
            Thread.sleep((attempt + 1) * 100);
        }
        catch (InterruptedException e) {
            LOG.debug("Retry process was interrupted. Exiting.", (Throwable)e);
        }
    }
}

