/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.context.odata.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.sdl.context.api.ContextMap;
import com.sdl.context.api.ContextVocabulary;
import com.sdl.context.api.definition.ContextPropertyType;
import com.sdl.context.api.engine.ContextEngine;
import com.sdl.context.api.exception.ResolverException;
import com.sdl.context.api.resolution.Evidence;
import com.sdl.context.odata.serialization.EvidenceSerializer;
import com.sdl.web.client.cache.CacheProvider;
import com.sdl.web.client.cache.CacheProviderInitializer;
import java.util.Properties;
import javax.cache.Cache;

public final class CachingContextEngine
implements ContextEngine {
    private static final String VOCABULARY_DEFAULT_KEY = "default";
    private ContextEngine contextEngine;
    private Cache<String, ContextMap> contextMapCache;
    private Cache<String, ContextVocabulary> contextVocabularyCache;
    private EvidenceSerializer evidenceSerializer = new EvidenceSerializer();
    private static CachingContextEngine instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CachingContextEngine getInstance(ContextEngine contextEngine, Properties properties) {
        if (instance != null) return instance;
        Class<CachingContextEngine> clazz = CachingContextEngine.class;
        synchronized (CachingContextEngine.class) {
            if (instance != null) return instance;
            instance = new CachingContextEngine(contextEngine, properties);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private CachingContextEngine(ContextEngine contextEngine, Properties properties) {
        this.contextEngine = contextEngine;
        CacheProvider cacheProvider = CacheProviderInitializer.getCacheProvider((Properties)properties);
        this.contextMapCache = cacheProvider.provideCacheForClass(String.class, ContextMap.class);
        this.contextVocabularyCache = cacheProvider.provideCacheForClass(String.class, ContextVocabulary.class);
    }

    public ContextMap resolve(Evidence evidence) throws ResolverException {
        ContextMap contextMap;
        String evidenceKey;
        try {
            evidenceKey = this.evidenceSerializer.serialize(evidence);
        }
        catch (JsonProcessingException e) {
            throw new ResolverException("Unable to serialize evidence into JSON key, cache will not be used", (Throwable)e);
        }
        if (this.contextMapCache.containsKey((Object)evidenceKey)) {
            contextMap = (ContextMap)this.contextMapCache.get((Object)evidenceKey);
        } else {
            contextMap = this.contextEngine.resolve(evidence);
            this.contextMapCache.put((Object)evidenceKey, (Object)contextMap);
        }
        return contextMap;
    }

    public ContextVocabulary getVocabulary() {
        ContextVocabulary vocabulary;
        if (this.contextVocabularyCache.containsKey((Object)VOCABULARY_DEFAULT_KEY)) {
            vocabulary = (ContextVocabulary)this.contextVocabularyCache.get((Object)VOCABULARY_DEFAULT_KEY);
        } else {
            vocabulary = this.contextEngine.getVocabulary();
            this.contextVocabularyCache.put((Object)VOCABULARY_DEFAULT_KEY, (Object)vocabulary);
        }
        return vocabulary;
    }

    public Object evaluateExpression(String expression, ContextPropertyType type) {
        return this.contextEngine.evaluateExpression(expression, type);
    }
}

