/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.context.odata.client.api;

import com.sdl.context.api.Aspect;
import com.sdl.context.api.ContextMap;
import com.sdl.context.api.ContextVocabulary;
import com.sdl.context.api.definition.ContextPropertyType;
import com.sdl.context.api.engine.ContextEngine;
import com.sdl.context.api.exception.ResolverException;
import com.sdl.context.api.resolution.Evidence;
import com.sdl.context.odata.client.CachingContextEngine;
import com.sdl.context.odata.client.ContextServiceClientConfiguration;
import com.sdl.context.odata.client.ODataContextEngineProxy;
import com.sdl.odata.client.api.exception.ODataClientRuntimeException;
import com.sdl.web.client.configuration.api.ConfigurationException;
import java.util.Properties;

public class ODataContextEngine
implements ContextEngine {
    private ContextEngine contextEngineProxy;

    public ODataContextEngine() {
        Properties odataClientProperties;
        ContextServiceClientConfiguration contextClientConfig = new ContextServiceClientConfiguration();
        try {
            odataClientProperties = contextClientConfig.readClientConfiguration();
            this.contextEngineProxy = new ODataContextEngineProxy(contextClientConfig);
        }
        catch (ConfigurationException e) {
            throw new ODataClientRuntimeException("Could not create OData Context client");
        }
        if (Boolean.parseBoolean(odataClientProperties.getProperty("CacheEnabled", "false"))) {
            this.contextEngineProxy = CachingContextEngine.getInstance(this.contextEngineProxy, odataClientProperties);
        }
    }

    public ContextMap<? extends Aspect> resolve(Evidence evidence) throws ResolverException {
        return this.contextEngineProxy.resolve(evidence);
    }

    public ContextVocabulary getVocabulary() {
        return this.contextEngineProxy.getVocabulary();
    }

    public Object evaluateExpression(String expression, ContextPropertyType type) {
        return this.contextEngineProxy.evaluateExpression(expression, type);
    }
}

