/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.context.odata.model;

import com.sdl.context.api.definition.ContextPropertyType;
import com.sdl.context.api.types.ContextSegmentPath;
import com.sdl.context.api.types.Version;
import com.sdl.context.odata.model.ODataContextPropertyType;
import com.sdl.context.odata.model.ODataContextSegmentPath;
import com.sdl.context.odata.model.ODataVersion;
import com.sdl.odata.api.edm.annotations.EdmComplex;
import com.sdl.odata.api.edm.annotations.EdmProperty;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

@EdmComplex(namespace="ODataContextualDelivery")
public class ODataContextPropertyValue
implements Serializable {
    @EdmProperty
    private Boolean booleanValue;
    @EdmProperty
    private Integer integerValue;
    @EdmProperty
    private Double floatValue;
    @EdmProperty
    private Set<String> setValue = new HashSet<String>();
    @EdmProperty
    private String stringValue;
    @EdmProperty
    private ODataVersion versionValue;
    @EdmProperty
    private ODataContextSegmentPath pathValue;
    @EdmProperty
    private ODataContextPropertyType type;

    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    public void setBooleanValue(Boolean booleanValue) {
        this.booleanValue = booleanValue;
    }

    public Integer getIntegerValue() {
        return this.integerValue;
    }

    public void setIntegerValue(Integer integerValue) {
        this.integerValue = integerValue;
    }

    public Double getFloatValue() {
        return this.floatValue;
    }

    public void setFloatValue(Double floatValue) {
        this.floatValue = floatValue;
    }

    public Set<String> getSetValue() {
        return this.setValue;
    }

    public void setSetValue(Set<String> setValue) {
        this.setValue = setValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public ODataVersion getVersionValue() {
        return this.versionValue;
    }

    public void setVersionValue(ODataVersion versionValue) {
        this.versionValue = versionValue;
    }

    public ODataContextSegmentPath getPathValue() {
        return this.pathValue;
    }

    public void setPathValue(ODataContextSegmentPath pathValue) {
        this.pathValue = pathValue;
    }

    public ODataContextPropertyType getType() {
        return this.type;
    }

    public void setType(ODataContextPropertyType type) {
        this.type = type;
    }

    public static ODataContextPropertyValue valueOf(Object objectValue, ContextPropertyType type) {
        ODataContextPropertyValue propertyValue = new ODataContextPropertyValue();
        switch (type) {
            case STRING: {
                propertyValue.setStringValue((String)objectValue);
                propertyValue.setType(ODataContextPropertyType.STRING);
                break;
            }
            case INTEGER: {
                propertyValue.setIntegerValue((Integer)objectValue);
                propertyValue.setType(ODataContextPropertyType.INTEGER);
                break;
            }
            case BOOLEAN: {
                propertyValue.setBooleanValue((Boolean)objectValue);
                propertyValue.setType(ODataContextPropertyType.BOOLEAN);
                break;
            }
            case FLOAT: {
                propertyValue.setFloatValue(Double.valueOf(objectValue.toString()));
                propertyValue.setType(ODataContextPropertyType.FLOAT);
                break;
            }
            case VERSION: {
                Version version = (Version)objectValue;
                propertyValue.setVersionValue(new ODataVersion(version.toString()));
                propertyValue.setType(ODataContextPropertyType.VERSION);
                break;
            }
            case SET: {
                propertyValue.setSetValue((Set)objectValue);
                propertyValue.setType(ODataContextPropertyType.SET);
                break;
            }
            case PATH: {
                ContextSegmentPath path = (ContextSegmentPath)objectValue;
                propertyValue.setPathValue(new ODataContextSegmentPath(path.getKey(), path.getSegments()));
                propertyValue.setType(ODataContextPropertyType.PATH);
                break;
            }
            default: {
                propertyValue.setStringValue(objectValue.toString());
                propertyValue.setType(ODataContextPropertyType.STRING);
            }
        }
        return propertyValue;
    }
}

