/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.cache.distributed;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisStorageClient {
    private static final Logger LOG = LoggerFactory.getLogger(RedisStorageClient.class);
    private JedisPool jedisPool;

    public RedisStorageClient(JedisPoolConfig config, String host, int port, Long timeout, String password) {
        this.jedisPool = password != null && password.length() > 0 ? new JedisPool((GenericObjectPoolConfig)config, host, port, timeout.intValue(), password) : new JedisPool((GenericObjectPoolConfig)config, host, port, timeout.intValue());
    }

    public byte[] get(byte[] serializedKey) {
        return this.execute(jedis -> {
            if (jedis.exists(serializedKey).booleanValue()) {
                return jedis.get(serializedKey);
            }
            return null;
        });
    }

    public Map<byte[], byte[]> get(Stream<byte[]> serializedKey) {
        return this.execute(jedis -> serializedKey.collect(Collectors.toMap(key -> key, key -> jedis.get(key))));
    }

    public String put(byte[] serializedKey, byte[] serializedValue, Integer expirationDuration) {
        return this.execute(jedis -> {
            String responseCode = jedis.set(serializedKey, serializedValue);
            if (expirationDuration != null) {
                jedis.expire(serializedKey, expirationDuration.intValue());
            }
            LOG.debug("Put key/value pair into redis storage, response code is {}", (Object)responseCode);
            return responseCode;
        });
    }

    public boolean containsKey(byte[] serializedKey) {
        return this.execute(jedis -> jedis.exists(serializedKey));
    }

    public boolean isClosed() {
        return this.jedisPool.isClosed();
    }

    private <T> T execute(Function<Jedis, T> jedisOperation) {
        try (Jedis resource = this.jedisPool.getResource();){
            T t = jedisOperation.apply(resource);
            return t;
        }
    }
}

