/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.configuration.api;

import com.sdl.web.client.configuration.ConfigurationPath;
import com.sdl.web.client.configuration.api.ConfigurationException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ConfigurationHolder {
    public static final Logger LOG = LoggerFactory.getLogger(ConfigurationHolder.class);

    default public boolean hasConfiguration(String path) {
        return this.hasConfiguration(new ConfigurationPath(path));
    }

    default public boolean hasConfiguration(ConfigurationPath path) {
        boolean hasConfiguration = false;
        try {
            this.getConfiguration(path);
            hasConfiguration = true;
        }
        catch (ConfigurationException e) {
            LOG.debug("Configuration for path: {} does not exists.", (Object)path);
        }
        return hasConfiguration;
    }

    default public ConfigurationHolder getConfiguration(String path) throws ConfigurationException {
        return this.getConfiguration(new ConfigurationPath(path));
    }

    public ConfigurationHolder getConfiguration(ConfigurationPath var1) throws ConfigurationException;

    public String getValue(String var1) throws ConfigurationException;

    public Map<String, String> getValues() throws ConfigurationException;
}

