/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.impl;

import com.sdl.odata.client.api.model.ODataIdAwareEntity;
import com.sdl.web.client.DiscoveryClient;
import com.sdl.web.client.EntityProvider;
import com.sdl.web.client.impl.DefaultDiscoveryClient;
import com.sdl.web.client.impl.OAuthTokenProvider;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class SecuredEntityProvider
implements EntityProvider {
    private final DiscoveryClient discoveryClient;
    private final OAuthTokenProvider tokenProvider;

    public SecuredEntityProvider(Properties properties) {
        Objects.requireNonNull(properties, "Configuration properties are required.");
        this.discoveryClient = new DefaultDiscoveryClient(properties);
        this.tokenProvider = new OAuthTokenProvider(properties);
    }

    @Override
    public <T extends ODataIdAwareEntity> Optional<T> getAwareEntity(Class<T> entityClazz, String ... expandParameters) {
        return this.discoveryClient.getAwareEntity(entityClazz, Optional.of(this.tokenProvider.getToken()), expandParameters);
    }

    @Override
    public <T extends ODataIdAwareEntity> List<T> getAwareEntities(Class<T> entityClazz, String ... expandParameters) {
        return this.discoveryClient.getAwareEntities(entityClazz, Optional.of(this.tokenProvider.getToken()), expandParameters);
    }
}

