/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.versions;

import com.sdl.web.client.versions.SupportedCisVersion;
import com.sdl.web.client.versions.Version;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentVersionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ContentVersionManager.class);
    private static final String SERVICE_VERSION_HEADER = "X-SDL-CIS-Version";
    public static final String DEFAULT_VERSION = "8.1.0";
    private Set<String> allMethods = new TreeSet<String>();
    private final Map<String, SupportedCisVersion> annotatedMethods;
    private final Version serviceVersion;

    public ContentVersionManager(String serviceUrl, Map<String, String> properties) {
        this.serviceVersion = new Version(this.loadServiceVersion(serviceUrl, properties));
        this.annotatedMethods = this.methodsWithAnnotation(this.getClasses(), SupportedCisVersion.class);
    }

    public ContentVersionManager(String serviceUrl, Properties properties) {
        this(serviceUrl, properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()))));
    }

    protected String loadServiceVersion(String cisUrl, Map<String, String> requestProperties) {
        try {
            URL url = new URL(cisUrl + "/$metadata");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            requestProperties.entrySet().stream().forEach(entry -> connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue()));
            String header = connection.getHeaderField(SERVICE_VERSION_HEADER);
            if (header != null && header.length() > 0) {
                return header;
            }
        }
        catch (Exception e) {
            LOG.debug("Unable to read {} from Service.", (Object)SERVICE_VERSION_HEADER, (Object)e);
        }
        return DEFAULT_VERSION;
    }

    public boolean isCompatible() {
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            String method = e.getClassName() + ":" + e.getMethodName();
            if (this.allMethods.contains(method)) continue;
            if (!this.annotatedMethods.containsKey(method)) {
                List<Class<?>> classes = this.getClasses();
                this.annotatedMethods.putAll(this.methodsWithAnnotation(classes, SupportedCisVersion.class));
                this.allMethods.addAll(this.methodsWithoutAnnotation(classes, SupportedCisVersion.class));
            }
            if (this.annotatedMethods.containsKey(method) && !this.inRange(this.annotatedMethods.get(method))) {
                return false;
            }
            this.allMethods.add(method);
        }
        return true;
    }

    protected List<Class<?>> getClasses() {
        try {
            Class<?> cl;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            for (cl = classLoader.getClass(); cl != ClassLoader.class; cl = cl.getSuperclass()) {
            }
            Field field = cl.getDeclaredField("classes");
            field.setAccessible(true);
            Vector classes = (Vector)((Vector)field.get(classLoader)).clone();
            return classes.stream().filter(this::getClassPredicate).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOG.trace("Unable to get loaded classes from classloader.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private boolean getClassPredicate(Class<?> c) {
        Package pkg = c.getPackage();
        if (pkg == null) {
            return false;
        }
        String pkgName = pkg.getName();
        return pkgName.startsWith("com.sdl") || pkgName.startsWith("com.tridion");
    }

    protected <T extends Annotation> Map<String, T> methodsWithAnnotation(List<Class<?>> classes, Class<T> annotation) {
        return classes.stream().flatMap(clazz -> this.findMethods((Class)clazz, m -> m.isAnnotationPresent(annotation))).collect(Collectors.toConcurrentMap(m -> m.getDeclaringClass().getName() + ":" + m.getName(), m -> m.getAnnotation(annotation)));
    }

    protected <T extends Annotation> Set<String> methodsWithoutAnnotation(List<Class<?>> classes, Class<T> annotation) {
        return classes.stream().flatMap(clazz -> this.findMethods((Class)clazz, m -> !m.isAnnotationPresent(annotation))).map(m -> m.getDeclaringClass().getName() + ":" + m.getName()).collect(Collectors.toSet());
    }

    private Stream<Method> findMethods(Class clazz, Predicate<Method> predicate) {
        try {
            return Arrays.asList(clazz.getDeclaredMethods()).stream().filter(predicate);
        }
        catch (NoClassDefFoundError e) {
            LOG.debug("Class is not analyzed by version manager.", (Throwable)e);
            return Stream.empty();
        }
    }

    private boolean inRange(SupportedCisVersion apiVersion) {
        Version from = new Version(apiVersion.from());
        Version to = new Version(apiVersion.to());
        return this.serviceVersion.isVersionInRangeOf(from, to);
    }

    public Version getServiceVersion() {
        return this.serviceVersion;
    }

    public boolean isHigherCISVersion(Version currentVersion) {
        return this.serviceVersion.isVersionInRangeOf(currentVersion, this.serviceVersion);
    }
}

