/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.cache;

import com.sdl.odata.client.property.PropertyUtils;
import com.sdl.web.client.cache.CacheProvider;
import com.sdl.web.client.cache.ServiceAvailabilityChecker;
import java.util.Properties;

public abstract class AbstractCacheProvider
implements CacheProvider {
    private boolean cacheEnabled;
    private Integer cacheExpirationPeriod;
    private boolean checkServiceAvailability;
    private ServiceAvailabilityChecker serviceChecker;

    @Override
    public void configure(Properties properties) {
        this.cacheExpirationPeriod = PropertyUtils.getIntegerProperty((Properties)properties, (String)"CacheExpirationDuration");
        this.cacheEnabled = Boolean.parseBoolean(properties.getProperty("CacheEnabled", "false")) && (this.cacheExpirationPeriod == null || this.cacheExpirationPeriod > 0);
        this.checkServiceAvailability = Boolean.parseBoolean(properties.getProperty("ServiceAvailabilityCheck", "false"));
        if (this.checkServiceAvailability) {
            this.serviceChecker = new ServiceAvailabilityChecker(properties.getProperty("ServiceUri"), this);
        }
    }

    @Override
    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    @Override
    public boolean needCheckHostAvailability() {
        return this.checkServiceAvailability;
    }

    @Override
    public ServiceAvailabilityChecker getServiceChecker() {
        return this.serviceChecker;
    }

    @Override
    public Integer getCacheExpirationPeriod() {
        return this.cacheExpirationPeriod;
    }
}

