/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.cache;

import com.sdl.odata.client.api.ODataClientQuery;
import com.sdl.web.client.cache.CacheProvider;
import com.sdl.web.client.cache.GeneralCacheProvider;
import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListenerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiredEntityListener<K, V>
implements CacheEntryExpiredListener<K, V>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ExpiredEntityListener.class);
    private CacheProvider cacheProvider;

    public ExpiredEntityListener(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public void onExpired(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
        if (!this.cacheProvider.getServiceChecker().isHostAvailable()) {
            for (CacheEntryEvent<K, V> cacheEntryEvent : events) {
                Cache<ODataClientQuery, Serializable> backupCache = ((GeneralCacheProvider)this.cacheProvider).provideBackupCacheForClass(ODataClientQuery.class, Serializable.class);
                LOG.warn("Service is not available. Put value into backup cache.");
                backupCache.put(cacheEntryEvent.getKey(), cacheEntryEvent.getValue());
            }
        }
    }
}

