/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.configuration;

import com.sdl.odata.client.ClientPropertiesBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;

public class CacheSecurityAwareClientPropertiesBuilder
extends ClientPropertiesBuilder {
    public CacheSecurityAwareClientPropertiesBuilder() {
    }

    public CacheSecurityAwareClientPropertiesBuilder(Map<String, String> configValues) {
        super(configValues);
        Properties properties = this.build();
        Arrays.asList("CacheEnabled", "CacheUri", "CacheExpirationDuration", "CacheClientId", "CachePassword", "CacheConnectionTimeout", "ClientId", "ClientSecret").forEach(key -> this.fillProperties(configValues, properties, (String)key));
    }

    private void fillProperties(Map<String, String> configValues, Properties propertiesToFill, String propertyKey) {
        String propertyValue = configValues.get(propertyKey);
        if (propertyValue != null) {
            propertiesToFill.setProperty(propertyKey, propertyValue);
        }
    }

    public CacheSecurityAwareClientPropertiesBuilder withCaching(boolean cacheEnabled) {
        this.build().setProperty("CacheEnabled", Boolean.toString(cacheEnabled));
        return this;
    }

    public CacheSecurityAwareClientPropertiesBuilder withCachingUri(String cacheUri) {
        this.build().setProperty("CacheUri", cacheUri);
        return this;
    }

    public CacheSecurityAwareClientPropertiesBuilder withCacheExpirationDuration(Long cacheExpirationTime) {
        this.build().setProperty("CacheExpirationDuration", cacheExpirationTime.toString());
        return this;
    }

    public CacheSecurityAwareClientPropertiesBuilder withClientId(String clientId) {
        this.build().setProperty("ClientId", clientId);
        return this;
    }

    public CacheSecurityAwareClientPropertiesBuilder withClientSecret(String clientSecret) {
        this.build().setProperty("ClientSecret", clientSecret);
        return this;
    }

    public CacheSecurityAwareClientPropertiesBuilder withServiceUri(String serviceUri) {
        super.withServiceUri(serviceUri);
        return this;
    }

    public CacheSecurityAwareClientPropertiesBuilder withClientTimeout(Integer timeout) {
        super.withClientTimeout(timeout);
        return this;
    }

    public CacheSecurityAwareClientPropertiesBuilder withProxyHostName(String proxyHostName) {
        super.withProxyHostName(proxyHostName);
        return this;
    }

    public CacheSecurityAwareClientPropertiesBuilder withProxyPort(Integer proxyPortNumber) {
        super.withProxyPort(proxyPortNumber);
        return this;
    }
}

