/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.configuration;

import com.sdl.web.client.configuration.XMLConfigurationHolder;
import com.sdl.web.client.configuration.api.ConfigurationException;
import com.sdl.web.client.configuration.api.XMLConfigurationReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLConfigurationReaderImpl
implements XMLConfigurationReader<XMLConfigurationHolder> {
    private static final Logger LOG = LoggerFactory.getLogger(XMLConfigurationReaderImpl.class);
    private static final DocumentBuilderFactory DOC_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final SchemaFactory SCHEMA_FACTORY = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

    @Override
    public XMLConfigurationHolder readConfiguration(String xmlFileName) throws ConfigurationException {
        Objects.requireNonNull(xmlFileName, "Configuration file name is required");
        LOG.debug("Reading configuration from: '{}'", (Object)xmlFileName);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(xmlFileName);
        if (inputStream != null) {
            return new XMLConfigurationHolder(this.loadConfiguration(new InputSource(inputStream)));
        }
        throw new ConfigurationException("Can't find configuration file: '" + xmlFileName + "'");
    }

    @Override
    public XMLConfigurationHolder readConfiguration(String xmlFileName, String schemaFileName) throws ConfigurationException {
        Objects.requireNonNull(xmlFileName, "Configuration file name is required");
        Objects.requireNonNull(schemaFileName, "Configuration schema file name is required");
        LOG.debug("Reading configuration from: '{}', validating with '{}'", (Object)xmlFileName, (Object)schemaFileName);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(xmlFileName);
        if (inputStream != null) {
            return new XMLConfigurationHolder(this.loadConfiguration(new InputSource(inputStream), schemaFileName));
        }
        throw new ConfigurationException("Can't find configuration file: '" + xmlFileName + "'");
    }

    private Node loadConfiguration(InputSource inputSource) throws ConfigurationException {
        try {
            Document doc = DOC_BUILDER_FACTORY.newDocumentBuilder().parse(inputSource);
            doc.getDocumentElement().normalize();
            return doc.getDocumentElement();
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ConfigurationException("Not possible to parse the XML configuration in '" + inputSource + "'", e);
        }
    }

    private Node loadConfiguration(InputSource inputSource, String schemaFileName) throws ConfigurationException {
        Node xmlNode;
        block17: {
            xmlNode = this.loadConfiguration(inputSource);
            try (InputStream schemaInputStream = this.getClass().getClassLoader().getResourceAsStream(this.escapeSpaces(schemaFileName));){
                if (schemaInputStream != null) {
                    Validator validator = SCHEMA_FACTORY.newSchema(new StreamSource(schemaInputStream)).newValidator();
                    try {
                        validator.validate(new DOMSource(xmlNode));
                        break block17;
                    }
                    catch (SAXException e) {
                        throw new ConfigurationException("Syntax error in XML configuration located at: '" + inputSource.getSystemId() + "'", e);
                    }
                }
                throw new ConfigurationException("No input stream opened for schema located at: '" + schemaFileName + "'");
            }
            catch (IOException | SAXException e) {
                throw new ConfigurationException("Syntax error in schema located at: '" + schemaFileName + "'", e);
            }
        }
        return xmlNode;
    }

    private String escapeSpaces(String input) {
        return input.replaceAll(" ", "%20");
    }
}

