/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.configuration.crypto;

import com.sdl.web.client.configuration.crypto.KeyProvider;
import com.sdl.web.client.configuration.crypto.SecurityPolicyUtil;
import com.sdl.web.client.configuration.crypto.SimpleKeyProvider;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;

public final class Crypto {
    private final KeyProvider keyProvider;

    public Crypto() {
        this.keyProvider = new SimpleKeyProvider();
    }

    public Crypto(KeyProvider keyProvider) {
        this.keyProvider = keyProvider;
    }

    public String encrypt(String secret) throws GeneralSecurityException {
        byte[] encrypted = this.cipher(secret.getBytes(), 1);
        return new String(Base64.getEncoder().encode(encrypted));
    }

    public String decrypt(String secret) throws GeneralSecurityException {
        byte[] decoded = Base64.getDecoder().decode(secret.getBytes());
        byte[] decrypted = this.cipher(decoded, 2);
        return new String(decrypted);
    }

    private byte[] cipher(byte[] secret, int mode) throws GeneralSecurityException {
        Key key = this.keyProvider.getKey();
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(mode, key);
        return cipher.doFinal(secret);
    }

    static {
        SecurityPolicyUtil.enforcePackageAccessPolicy("com.sdl.web.client.configuration.crypto.");
    }
}

