/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.cache;

import com.sdl.web.client.cache.CacheProvider;
import com.sdl.web.client.cache.GeneralCacheProvider;
import com.sdl.web.discovery.util.CommonUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheProviderInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(CacheProviderInitializer.class);

    private CacheProviderInitializer() {
    }

    public static CacheProvider getCacheProvider(Properties properties) {
        CacheProvider cacheProvider;
        String cacheProviderClassName = properties.getProperty("CacheProviderClass");
        if (CommonUtils.isBlank((CharSequence)cacheProviderClassName)) {
            cacheProvider = CacheProviderInitializer.logAndGetDefaultCache(cacheProviderClassName);
        } else {
            try {
                Class<?> cacheProviderClass = Class.forName(cacheProviderClassName);
                Constructor<?> cacheProviderConstructor = cacheProviderClass.getDeclaredConstructor(new Class[0]);
                cacheProviderConstructor.setAccessible(true);
                cacheProvider = (CacheProvider)cacheProviderConstructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                cacheProvider = CacheProviderInitializer.logAndGetDefaultCache(cacheProviderClassName);
            }
        }
        cacheProvider.configure(properties);
        return cacheProvider;
    }

    private static CacheProvider logAndGetDefaultCache(String cacheProviderClassName) {
        LOG.debug("Unable to initialize cache provider using configuration {}: '{}'. Using default GeneralCacheProvider", (Object)"CacheProviderClass", (Object)cacheProviderClassName);
        return new GeneralCacheProvider();
    }
}

