/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.cache;

import com.sdl.odata.client.api.ODataClientQuery;
import com.sdl.web.client.cache.CacheProvider;
import com.sdl.web.client.cache.GeneralCacheProvider;
import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListenerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiredEntityListener<K, V>
implements CacheEntryExpiredListener<K, V>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ExpiredEntityListener.class);
    private CacheProvider cacheProvider;
    private Class<? extends Serializable> cacheKeyClass;
    private Class<? extends Serializable> cacheValueClass;

    public ExpiredEntityListener(CacheProvider cacheProvider, Class<? extends Serializable> cacheKeyClass, Class<? extends Serializable> cacheValueClass) {
        this.cacheProvider = cacheProvider;
        this.cacheKeyClass = cacheKeyClass;
        this.cacheValueClass = cacheValueClass;
    }

    public void onExpired(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
        if (!this.cacheProvider.getServiceChecker().isHostAvailable()) {
            for (CacheEntryEvent<K, V> cacheEntryEvent : events) {
                Cache<? extends Serializable, ? extends Serializable> backupCache = ((GeneralCacheProvider)this.cacheProvider).provideBackupCacheForClass(this.cacheKeyClass, this.cacheValueClass);
                LOG.warn("Service is not available. Put value into backup cache.");
                backupCache.put(cacheEntryEvent.getKey() instanceof ODataClientQuery ? ((ODataClientQuery)cacheEntryEvent.getKey()).getCacheKey() : cacheEntryEvent.getKey(), cacheEntryEvent.getValue());
            }
        }
    }
}

