/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.cache;

import com.sdl.web.client.cache.AbstractCacheProvider;
import com.sdl.web.client.cache.CacheUtil;
import com.sdl.web.client.cache.ExpiredEntityListener;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ModifiedExpiryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralCacheProvider
extends AbstractCacheProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralCacheProvider.class);
    private CacheManager cacheManager;

    @Override
    public void configure(Properties properties) {
        super.configure(properties);
        this.cacheManager = this.getCacheManager(properties.getProperty("CacheUri"));
    }

    @Override
    public <K extends Serializable, V extends Serializable> Cache<K, V> provideCacheForClass(Class<K> cacheKeyClass, Class<V> cacheValueClass, String cacheName) {
        MutableConfiguration cacheConfiguration = new MutableConfiguration().setTypes(cacheKeyClass, cacheValueClass).setExpiryPolicyFactory(ModifiedExpiryPolicy.factoryOf((Duration)(this.getCacheExpirationPeriod() == null ? Duration.FIVE_MINUTES : new Duration(TimeUnit.SECONDS, (long)this.getCacheExpirationPeriod().intValue())))).setStatisticsEnabled(true);
        if (this.needCheckHostAvailability()) {
            cacheConfiguration.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)new MutableCacheEntryListenerConfiguration(FactoryBuilder.factoryOf(new ExpiredEntityListener(this, cacheKeyClass, cacheValueClass)), null, true, true));
        }
        LOG.debug("Cache Manager URI {}", (Object)this.cacheManager.getURI());
        Cache<K, V> resultCache = this.getCache(cacheKeyClass, cacheValueClass, cacheName, cacheConfiguration);
        return resultCache;
    }

    public <K extends Serializable, V extends Serializable> Cache<K, V> provideBackupCacheForClass(Class<K> cacheKeyClass, Class<V> cacheValueClass) {
        String cacheName = CacheUtil.getBackupCacheName(cacheValueClass.getName());
        MutableConfiguration<K, V> cacheConfiguration = CacheUtil.getBackupCacheConfiguration(cacheKeyClass, cacheValueClass);
        LOG.debug("Backup Cache Manager URI {}", (Object)this.cacheManager.getURI());
        return this.getCache(cacheKeyClass, cacheValueClass, cacheName, cacheConfiguration);
    }

    private <K extends Serializable, V extends Serializable> Cache<K, V> getCache(Class<K> cacheKeyClass, Class<V> cacheValueClass, String cacheName, MutableConfiguration<K, V> cacheConfiguration) {
        Cache resultCache = this.cacheManager.getCache(cacheName, cacheKeyClass, cacheValueClass);
        LOG.debug("Got cache {}", (Object)resultCache);
        if (resultCache == null) {
            LOG.debug("There is no existing cache with name '{}'", (Object)cacheName);
            resultCache = this.cacheManager.createCache(cacheName, cacheConfiguration);
            LOG.debug("Created cache {}", (Object)resultCache);
        }
        return resultCache;
    }

    public void removeBackupCache() {
        for (String cacheName : this.cacheManager.getCacheNames()) {
            if (!cacheName.endsWith("_backup")) continue;
            LOG.debug("Removing backup cache {}", (Object)cacheName);
            this.cacheManager.destroyCache(cacheName);
        }
    }

    private CacheManager getCacheManager(String cacheManagerUri) {
        Path configPath;
        if (cacheManagerUri == null || cacheManagerUri.isEmpty()) {
            cacheManagerUri = "ehcache-default.xml";
        }
        if (Files.exists(configPath = Paths.get(cacheManagerUri, new String[0]), new LinkOption[0])) {
            return Caching.getCachingProvider().getCacheManager(configPath.toUri(), null);
        }
        URL cacheManagerUrl = this.getClass().getClassLoader().getResource(cacheManagerUri);
        if (cacheManagerUrl != null) {
            try {
                return Caching.getCachingProvider().getCacheManager(cacheManagerUrl.toURI(), null);
            }
            catch (Exception e) {
                LOG.debug("Could not create CacheManager for URI {}. Trying default.", (Object)cacheManagerUri);
            }
        }
        return Caching.getCachingProvider().getCacheManager();
    }
}

