/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.cache;

import com.sdl.web.client.cache.CacheProvider;
import com.sdl.web.client.cache.GeneralCacheProvider;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceAvailabilityChecker {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceAvailabilityChecker.class);
    private static final List<Integer> VALID_HTTP_RESPONSE_CODES = Arrays.asList(200, 400, 401);
    private static final int HTTP_NOT_FOUND = 404;
    private boolean becameNotAvailable = false;
    private String serviceURL;
    private CacheProvider cacheProvider;

    public ServiceAvailabilityChecker(String newServiceURL, CacheProvider cacheProvider) {
        this.serviceURL = newServiceURL;
        this.cacheProvider = cacheProvider;
    }

    public boolean isHostAvailable() {
        int httpResponseCode = this.pingService();
        boolean isAvailable = VALID_HTTP_RESPONSE_CODES.stream().anyMatch(code -> code == httpResponseCode);
        if (isAvailable && this.becameNotAvailable && this.cacheProvider instanceof GeneralCacheProvider) {
            ((GeneralCacheProvider)this.cacheProvider).removeBackupCache();
        }
        if (!isAvailable && !this.becameNotAvailable) {
            this.becameNotAvailable = true;
        }
        return isAvailable;
    }

    private int pingService() {
        try {
            LOG.trace("Checking {} if is up and running", (Object)this.serviceURL);
            HttpURLConnection conn = (HttpURLConnection)new URL(this.serviceURL).openConnection();
            return conn.getResponseCode();
        }
        catch (IOException e) {
            LOG.error("An error occurred while trying to connect to service", (Throwable)e);
            return 404;
        }
    }
}

