/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.cache.distributed;

import com.sdl.web.client.cache.distributed.RedisStorageClient;
import com.sdl.web.client.configuration.ClientConstants;
import com.sdl.web.discovery.util.CommonUtils;
import com.sdl.web.discovery.util.SerializeUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPoolConfig;

public class RedisCache<K extends Serializable, V extends Serializable>
implements Cache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(RedisCache.class);
    private RedisStorageClient redisClient;
    private String clientId;
    private String cacheName;
    private byte[] serializedCacheName;
    private Integer cacheExpirationDuration;
    private Integer compressionThreshold;

    private RedisCache(Builder redisCacheBuilder) {
        CommonUtils.checkArgument((!CommonUtils.isBlank((CharSequence)redisCacheBuilder.clientId) ? 1 : 0) != 0, (Object)"Cache client id can not be empty");
        CommonUtils.checkArgument((!CommonUtils.isBlank((CharSequence)redisCacheBuilder.cacheName) ? 1 : 0) != 0, (Object)"Cache name can not be empty");
        CommonUtils.checkArgument((!CommonUtils.isBlank((CharSequence)redisCacheBuilder.host) ? 1 : 0) != 0, (Object)"Redis cache host can not be empty");
        CommonUtils.checkArgument((redisCacheBuilder.port > 0 ? 1 : 0) != 0, (Object)"Redis cache port must be greater than zero");
        CommonUtils.checkArgument((redisCacheBuilder.timeout > 0L ? 1 : 0) != 0, (Object)"Redis cache timeout must be greater than zero");
        this.clientId = redisCacheBuilder.clientId;
        this.cacheName = redisCacheBuilder.cacheName;
        this.compressionThreshold = redisCacheBuilder.compressionThreshold;
        this.serializedCacheName = SerializeUtils.serialize((Serializable)((Object)this.cacheName), (int)this.compressionThreshold);
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(redisCacheBuilder.jedisPoolMaxTotal.intValue());
        jedisPoolConfig.setTestWhileIdle(redisCacheBuilder.jedisPoolTestWhileIdle.booleanValue());
        this.redisClient = new RedisStorageClient(jedisPoolConfig, redisCacheBuilder.host, redisCacheBuilder.port, redisCacheBuilder.timeout, redisCacheBuilder.password);
        this.cacheExpirationDuration = redisCacheBuilder.cacheExpirationDuration;
        LOG.debug("Distributed cache initialized");
    }

    public V get(K key) {
        byte[] serializedValue = this.redisClient.get(this.getCacheKey(key));
        return (V)(serializedValue == null ? null : (Serializable)SerializeUtils.deserialize((byte[])serializedValue));
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        return this.redisClient.get(keys.stream().map(key -> this.getCacheKey(key))).entrySet().stream().collect(Collectors.toMap(entry -> (Serializable)SerializeUtils.deserialize((byte[])((byte[])entry.getKey())), entry -> entry.getValue() == null ? null : (Serializable)SerializeUtils.deserialize((byte[])((byte[])entry.getValue()))));
    }

    public boolean containsKey(K key) {
        return this.redisClient.containsKey(this.getCacheKey(key));
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        throw new UnsupportedOperationException("Method 'loadAll' is not implemented");
    }

    public void put(K key, V value) {
        this.redisClient.put(this.getCacheKey(key), SerializeUtils.serialize(value, (int)this.compressionThreshold), this.cacheExpirationDuration);
    }

    public V getAndPut(K key, V value) {
        throw new UnsupportedOperationException("Method 'getAndPut' is not implemented");
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException("Method 'putAll' is not implemented");
    }

    public boolean putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException("Method 'putIfAbsent' is not implemented");
    }

    public boolean remove(K key) {
        throw new UnsupportedOperationException("Method 'remove' is not implemented");
    }

    public boolean remove(K key, V oldValue) {
        throw new UnsupportedOperationException("Method 'remove' is not implemented");
    }

    public V getAndRemove(K key) {
        throw new UnsupportedOperationException("Method 'getAndRemove' is not implemented");
    }

    public boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException("Method 'replace' is not implemented");
    }

    public boolean replace(K key, V value) {
        throw new UnsupportedOperationException("Method 'replace' is not implemented");
    }

    public V getAndReplace(K key, V value) {
        throw new UnsupportedOperationException("Method 'getAndReplace' is not implemented");
    }

    public void removeAll(Set<? extends K> keys) {
        throw new UnsupportedOperationException("Method 'removeAll' is not implemented");
    }

    public void removeAll() {
        throw new UnsupportedOperationException("Method 'removeAll' is not implemented");
    }

    public void clear() {
        throw new UnsupportedOperationException("Method 'clear' is not implemented");
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> aClass) {
        throw new UnsupportedOperationException("Method 'getConfiguration' is not implemented");
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        throw new UnsupportedOperationException("Method 'invoke' is not implemented");
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> set, EntryProcessor<K, V, T> entryProcessor, Object ... objects) {
        throw new UnsupportedOperationException("Method 'invokeAll' is not implemented");
    }

    public String getName() {
        return this.cacheName;
    }

    public CacheManager getCacheManager() {
        throw new UnsupportedOperationException("Method 'getCacheManager' is not implemented");
    }

    public void close() {
        throw new UnsupportedOperationException("Method 'close' is not implemented");
    }

    public boolean isClosed() {
        return this.redisClient.isClosed();
    }

    public <T> T unwrap(Class<T> clazz) {
        throw new UnsupportedOperationException("Method 'unwrap' is not implemented");
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        throw new UnsupportedOperationException("Method 'registerCacheEntryListener' is not implemented");
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        throw new UnsupportedOperationException("Method 'deregisterCacheEntryListener' is not implemented");
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        throw new UnsupportedOperationException("Method 'iterator' is not implemented");
    }

    private byte[] getCacheKey(K key) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] serializedKey = SerializeUtils.serialize(key, (int)this.compressionThreshold);
        try {
            outputStream.write(SerializeUtils.serialize((Serializable)((Object)this.clientId), (int)this.compressionThreshold));
            outputStream.write(this.serializedCacheName);
            outputStream.write(serializedKey);
        }
        catch (IOException e) {
            LOG.warn("Unable to append cache name for redis key, using simple key");
            return serializedKey;
        }
        return outputStream.toByteArray();
    }

    public static class Builder {
        private String clientId;
        private String cacheName;
        private String host;
        private Integer port;
        private String password;
        private Long timeout;
        private Integer cacheExpirationDuration;
        private Integer compressionThreshold = ClientConstants.Cache.CLIENT_CACHE_COMPRESSION_THRESHOLD_DEFAULT;
        private Integer jedisPoolMaxTotal = ClientConstants.Cache.CLIENT_CACHE_REDIS_POOL_MAX_TOTAL_DEFAULT;
        private Boolean jedisPoolTestWhileIdle = ClientConstants.Cache.CLIENT_CACHE_REDIS_POOL_TEST_WHILE_IDLE_DEFAULT;

        public Builder withClientId(String newClientId) {
            this.clientId = newClientId;
            return this;
        }

        public Builder withCacheName(String newCacheName) {
            this.cacheName = newCacheName;
            return this;
        }

        public Builder withHost(String newHost) {
            this.host = newHost;
            return this;
        }

        public Builder withPort(Integer newPort) {
            this.port = newPort;
            return this;
        }

        public Builder withPassword(String newPassword) {
            this.password = newPassword;
            return this;
        }

        public Builder withTimeout(Long newTimeout) {
            this.timeout = newTimeout;
            return this;
        }

        public Builder withCacheExpirationDuration(Integer newCacheExpirationDuration) {
            this.cacheExpirationDuration = newCacheExpirationDuration;
            return this;
        }

        public Builder withCompressionThreshold(Integer newCompressionThreshold) {
            this.compressionThreshold = newCompressionThreshold;
            return this;
        }

        public Builder withJedisPoolMaxTotal(Integer newJedisPoolMaxTotal) {
            this.jedisPoolMaxTotal = newJedisPoolMaxTotal;
            return this;
        }

        public Builder withJedisPoolTestWhileIdle(Boolean newJedisPoolTestWhileIdle) {
            this.jedisPoolTestWhileIdle = newJedisPoolTestWhileIdle;
            return this;
        }

        public RedisCache build() {
            return new RedisCache(this);
        }
    }
}

