/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.cache.distributed;

import com.sdl.odata.client.property.PropertyUtils;
import com.sdl.web.client.cache.AbstractCacheProvider;
import com.sdl.web.client.cache.distributed.RedisCache;
import com.sdl.web.client.configuration.ClientConstants;
import com.sdl.web.discovery.util.CommonUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCacheProvider
extends AbstractCacheProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RedisCacheProvider.class);
    private String distributedCacheClientId;
    private String distributedCacheHost;
    private Integer distributedCachePort;
    private String distributedCachePassword;
    private Long distributedCacheTimeout;
    private Integer compressionThreshold;
    private Integer jedisPoolMaxTotal;
    private Boolean jedisPoolTestWhileIdle;
    private Map<String, RedisCache> cacheMap = new HashMap<String, RedisCache>();

    @Override
    public void configure(Properties properties) {
        LOG.debug("Configuring RedisCacheProvider");
        super.configure(properties);
        this.distributedCacheClientId = properties.getProperty("CacheClientId", "defaultCacheClientId");
        String cacheUri = PropertyUtils.getStringProperty((Properties)properties, (String)"CacheUri");
        if (CommonUtils.isBlank((CharSequence)cacheUri)) {
            throw new IllegalArgumentException("Wrong or blank CacheUri: " + cacheUri);
        }
        String[] cacheUriSplitted = cacheUri.split(":");
        if (cacheUriSplitted.length < 2) {
            LOG.warn("'{}' has a wrong format: '{}'. It should consists of a valid URL to a redis storage with appropriate port separated by ':' sign", (Object)"CacheUri", (Object)cacheUri);
        } else {
            this.distributedCacheHost = cacheUriSplitted[0];
            this.distributedCachePort = Integer.valueOf(cacheUriSplitted[1]);
        }
        this.distributedCachePassword = PropertyUtils.getStringProperty((Properties)properties, (String)"CachePassword");
        this.distributedCacheTimeout = PropertyUtils.getLongProperty((String)properties.getProperty("CacheConnectionTimeout", "10000"));
        this.compressionThreshold = PropertyUtils.getIntegerProperty((Properties)properties, (String)"CacheCompressionThreshold", (Integer)ClientConstants.Cache.CLIENT_CACHE_COMPRESSION_THRESHOLD_DEFAULT);
        this.jedisPoolMaxTotal = PropertyUtils.getIntegerProperty((Properties)properties, (String)"CacheRedisPoolMaxTotal", (Integer)ClientConstants.Cache.CLIENT_CACHE_REDIS_POOL_MAX_TOTAL_DEFAULT);
        String jedisPoolTestWhileIdleString = PropertyUtils.getStringProperty((Properties)properties, (String)"CacheRedisPoolTestWhileIdle");
        this.jedisPoolTestWhileIdle = CommonUtils.isBlank((CharSequence)jedisPoolTestWhileIdleString) ? ClientConstants.Cache.CLIENT_CACHE_REDIS_POOL_TEST_WHILE_IDLE_DEFAULT : Boolean.valueOf(jedisPoolTestWhileIdleString);
    }

    @Override
    public <K extends Serializable, V extends Serializable> Cache<K, V> provideCacheForClass(Class<K> cacheKeyClass, Class<V> cacheValueClass, String cacheName) {
        RedisCache cache = this.cacheMap.get(cacheName);
        if (cache == null) {
            LOG.debug("No cache with name {}, initializing...", (Object)cacheName);
            cache = new RedisCache.Builder().withClientId(this.distributedCacheClientId).withCacheName(cacheName).withHost(this.distributedCacheHost).withPort(this.distributedCachePort).withPassword(this.distributedCachePassword).withTimeout(this.distributedCacheTimeout).withCacheExpirationDuration(this.getCacheExpirationPeriod()).withCompressionThreshold(this.compressionThreshold).withJedisPoolMaxTotal(this.jedisPoolMaxTotal).withJedisPoolTestWhileIdle(this.jedisPoolTestWhileIdle).build();
            this.cacheMap.put(cacheName, cache);
            LOG.debug("Initialized cache with name {}", (Object)cacheName);
        }
        return cache;
    }
}

