/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.configuration;

import com.sdl.web.client.TokenProvider;
import com.sdl.web.client.impl.OAuthTokenProvider;
import com.tridion.util.ReflectionUtil;
import com.tridion.util.StringUtils;
import com.tridion.util.TridionReflectionException;
import java.util.Properties;

public class TokenProviderFactory {
    public static TokenProviderFactory getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public TokenProvider getTokenProvider(Properties properties) throws TridionReflectionException {
        if (properties.containsKey("TokenProvider")) {
            String providerClass = StringUtils.trimIfNotNull((String)properties.getProperty("TokenProvider"));
            return (TokenProvider)ReflectionUtil.loadClassInstance((String)providerClass, TokenProvider.class, (Object[])new Object[]{properties});
        }
        return this.getDefaultTokenProvider(properties);
    }

    public TokenProvider getDefaultTokenProvider(Properties properties) throws TridionReflectionException {
        return new OAuthTokenProvider(properties);
    }

    private static class InstanceHolder {
        private static final TokenProviderFactory INSTANCE = new TokenProviderFactory();

        private InstanceHolder() {
        }
    }
}

