/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.configuration;

import com.sdl.web.client.configuration.ConfigurationPath;
import com.sdl.web.client.configuration.api.ConfigurationException;
import com.sdl.web.client.configuration.api.ConfigurationHolder;
import com.sdl.web.client.configuration.crypto.Crypto;
import com.tridion.configuration.VariableResolverUtil;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLConfigurationHolder
implements ConfigurationHolder {
    private static final String ENCRYPTED_PREFIX = "encrypted:";
    private final Node xmlConfiguration;
    private final Crypto crypto;

    public XMLConfigurationHolder(Node xmlConfiguration) {
        this.xmlConfiguration = Objects.requireNonNull(xmlConfiguration, "XML Configuration should not be null!");
        this.crypto = new Crypto();
    }

    @Override
    public ConfigurationHolder getConfiguration(ConfigurationPath path) throws ConfigurationException {
        Objects.requireNonNull(path, "Configuration path not defined");
        Node currentNode = this.xmlConfiguration;
        for (String pathSegment : path.getPathSegments()) {
            if (((Element)currentNode).getElementsByTagName(pathSegment).getLength() == 0) {
                throw new ConfigurationException("The provided path does not exists in configuration file.");
            }
            currentNode = ((Element)currentNode).getElementsByTagName(pathSegment).item(0);
        }
        return new XMLConfigurationHolder(currentNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValue(String name) throws ConfigurationException {
        XMLConfigurationHolder xMLConfigurationHolder = this;
        synchronized (xMLConfigurationHolder) {
            return this.decrypt(VariableResolverUtil.resolveValue((String)((Element)this.xmlConfiguration).getAttribute(name)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getValues() throws ConfigurationException {
        HashMap<String, String> values = new HashMap<String, String>();
        XMLConfigurationHolder xMLConfigurationHolder = this;
        synchronized (xMLConfigurationHolder) {
            NamedNodeMap attributes = this.xmlConfiguration.getAttributes();
            for (int attributeIndex = 0; attributeIndex < attributes.getLength(); ++attributeIndex) {
                Node attribute = attributes.item(attributeIndex);
                values.put(attribute.getNodeName(), this.decrypt(VariableResolverUtil.resolveValue((String)attribute.getNodeValue())));
            }
        }
        return values;
    }

    private String decrypt(String item) throws ConfigurationException {
        if (item != null && item.startsWith(ENCRYPTED_PREFIX) && item.length() > ENCRYPTED_PREFIX.length()) {
            String encryptedItem = item.substring(ENCRYPTED_PREFIX.length());
            try {
                return this.crypto.decrypt(encryptedItem);
            }
            catch (GeneralSecurityException e) {
                throw new ConfigurationException("Could not decrypt attribute", e);
            }
        }
        return item;
    }
}

