/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.configuration.crypto;

import com.sdl.web.client.configuration.crypto.KeyProvider;
import com.sdl.web.client.configuration.crypto.SecurityPolicyUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;

final class SimpleKeyProvider
implements KeyProvider {
    private static final String ALGORITHM = "AES";
    private static final int KEY_BYTES_LENGTH = 16;

    SimpleKeyProvider() {
    }

    @Override
    public Key getKey() {
        byte[] key = this.generateKey();
        return new SecretKeySpec(key, ALGORITHM);
    }

    private byte[] generateKey() {
        byte[] key = new byte[16];
        for (int i = 0; i < key.length; ++i) {
            key[i] = Byte.parseByte("" + (i * i + i - 1) % 127);
        }
        return key;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void writeObject(ObjectInputStream in) throws IOException {
        throw new IOException("Class cannot be serialized");
    }

    protected void readObject(ObjectInputStream in) throws IOException {
        throw new IOException("Class cannot be deserialized");
    }

    static {
        SecurityPolicyUtil.enforcePackageAccessPolicy("com.tridion.crypto.");
    }
}

