/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.impl;

import com.sdl.web.client.CapabilityProvider;
import com.sdl.web.client.cache.CacheProvider;
import com.sdl.web.client.cache.CacheProviderInitializer;
import com.sdl.web.discovery.datalayer.model.Capability;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import javax.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingCapabilityProvider
implements CapabilityProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CachingCapabilityProvider.class);
    private final CapabilityProvider capabilityProvider;
    private final CacheProvider cacheProvider;

    public CachingCapabilityProvider(CapabilityProvider capabilityProvider, Properties properties) {
        this.capabilityProvider = capabilityProvider;
        this.cacheProvider = CacheProviderInitializer.getCacheProvider(properties);
    }

    @Override
    public <T extends Capability> Optional<T> getCapability(Class<T> capabilityClazz, String ... expandParameters) {
        if (this.cacheProvider.isCacheEnabled()) {
            LOG.trace("Caching is enabled. Using it for getting capability.");
            Cache<Serializable, T> cache = this.cacheProvider.provideCacheForClass(Serializable.class, capabilityClazz);
            Capability cachedCapability = (Capability)cache.get(capabilityClazz);
            if (cachedCapability != null) {
                LOG.trace("Getting capability from cache by key: {}", capabilityClazz);
                return Optional.of(cachedCapability);
            }
            Optional<T> capability = this.capabilityProvider.getCapability(capabilityClazz, expandParameters);
            if (capability.isPresent()) {
                LOG.trace("Putting configuration resource into cache with key {}", capabilityClazz);
                cache.put(capabilityClazz, capability.get());
            }
            return capability;
        }
        LOG.trace("Caching is disabled, getting capability resource using provider.");
        return this.capabilityProvider.getCapability(capabilityClazz, expandParameters);
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }
}

