/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.impl;

import com.sdl.odata.client.api.model.ODataIdAwareEntity;
import com.sdl.web.client.EntityProvider;
import com.sdl.web.client.cache.CacheProvider;
import com.sdl.web.client.cache.CacheProviderInitializer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingEntityProvider
implements EntityProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CachingEntityProvider.class);
    private final EntityProvider entityProvider;
    private final CacheProvider cacheProvider;

    public CachingEntityProvider(EntityProvider provider, Properties properties) {
        this.entityProvider = provider;
        this.cacheProvider = CacheProviderInitializer.getCacheProvider(properties);
    }

    @Override
    public <T extends ODataIdAwareEntity> Optional<T> getAwareEntity(Class<T> provider, String ... expandParameters) {
        if (this.cacheProvider.isCacheEnabled()) {
            LOG.trace("Caching is enabled. Using it for getting capability.");
            Cache<Serializable, T> cache = this.cacheProvider.provideCacheForClass(Serializable.class, provider);
            ODataIdAwareEntity cachedEntity = (ODataIdAwareEntity)cache.get(provider);
            if (cachedEntity != null) {
                LOG.trace("Getting entity from cache by key: {}", provider);
                return Optional.of(cachedEntity);
            }
            Optional<T> entity = this.entityProvider.getAwareEntity(provider, expandParameters);
            if (entity.isPresent()) {
                LOG.trace("Putting configuration resource into cache with key {}", provider);
                cache.put(provider, entity.get());
            }
            return entity;
        }
        LOG.trace("Caching is disabled, getting capability resource using provider.");
        return this.entityProvider.getAwareEntity(provider, expandParameters);
    }

    @Override
    public <T extends ODataIdAwareEntity> List<T> getAwareEntities(Class<T> entityClazz, String ... expandParameters) {
        if (this.cacheProvider.isCacheEnabled()) {
            LOG.trace("Caching is enabled. Using it for getting entities.");
            Cache<Serializable, ArrayList> cache = this.cacheProvider.provideCacheForClass(Serializable.class, ArrayList.class);
            List cachedEntityList = (List)cache.get(entityClazz);
            if (cachedEntityList != null) {
                LOG.trace("Getting entity from cache by key: {}", entityClazz);
                return cachedEntityList;
            }
            List<T> entities = this.entityProvider.getAwareEntities(entityClazz, expandParameters);
            if (!entities.isEmpty()) {
                LOG.trace("Putting configuration resource into cache with key {}", entityClazz);
                cache.put(entityClazz, (Object)((ArrayList)entities));
            }
            return entities;
        }
        LOG.trace("Caching is disabled, getting capability resource using entityClazz.");
        return this.entityProvider.getAwareEntities(entityClazz, expandParameters);
    }
}

