/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.impl;

import com.sdl.web.client.CapabilityProvider;
import com.sdl.web.client.ClientException;
import com.sdl.web.client.impl.CachingCapabilityProvider;
import com.sdl.web.client.impl.DefaultCapabilityProvider;
import com.sdl.web.client.impl.SecuredCapabilityProvider;
import java.util.Properties;

public class CapabilityProviderFactory {
    private CapabilityProviderFactory() {
    }

    public static CapabilityProvider getCachingSecuredCapabilityProvider(Properties properties) throws ClientException {
        return new CachingCapabilityProvider(CapabilityProviderFactory.getSecuredCapabilityProvider(properties), properties);
    }

    public static CapabilityProvider getSecuredCapabilityProvider(Properties properties) {
        return new SecuredCapabilityProvider(properties);
    }

    public static CapabilityProvider getCapabilityProvider(Properties properties) {
        return new DefaultCapabilityProvider(properties);
    }

    public static CapabilityProvider getCachingDefaultCapabilityProvider(Properties properties) throws ClientException {
        return new CachingCapabilityProvider(CapabilityProviderFactory.getCapabilityProvider(properties), properties);
    }

    public static CapabilityProvider getCapabilityProvider(boolean secured, boolean cached, Properties properties) throws ClientException {
        if (secured && cached) {
            return CapabilityProviderFactory.getCachingSecuredCapabilityProvider(properties);
        }
        if (secured) {
            return CapabilityProviderFactory.getSecuredCapabilityProvider(properties);
        }
        if (cached) {
            return CapabilityProviderFactory.getCachingDefaultCapabilityProvider(properties);
        }
        return CapabilityProviderFactory.getCapabilityProvider(properties);
    }
}

