/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.impl;

import com.sdl.odata.client.BasicODataClientQuery;
import com.sdl.odata.client.ODataClientFactoryImpl;
import com.sdl.odata.client.ODataV4ClientComponentsProvider;
import com.sdl.odata.client.URLConnectionRequestPropertiesBuilder;
import com.sdl.odata.client.api.ODataClient;
import com.sdl.odata.client.api.ODataClientComponentsProvider;
import com.sdl.odata.client.api.ODataClientFactory;
import com.sdl.odata.client.api.ODataClientQuery;
import com.sdl.odata.client.api.exception.ODataClientRuntimeException;
import com.sdl.odata.client.api.model.ODataIdAwareEntity;
import com.sdl.odata.client.property.PropertyUtils;
import com.sdl.web.client.DiscoveryClient;
import com.sdl.web.client.configuration.CacheSecurityAwareClientPropertiesBuilder;
import com.sdl.web.client.impl.util.ClientsUtil;
import com.sdl.web.client.versions.ContentVersionManager;
import com.sdl.web.discovery.datalayer.model.Capability;
import com.sdl.web.discovery.datalayer.model.EntitiesRegistry;
import com.sdl.web.discovery.datalayer.model.TokenServiceCapability;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDiscoveryClient
implements DiscoveryClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDiscoveryClient.class);
    private static final List<String> EDM_ENTITY_CLASSES = EntitiesRegistry.ALL_EDM_ENTITIES.stream().map(Class::getName).collect(Collectors.toList());
    private Properties properties;
    private final ODataClientFactory clientFactory = new ODataClientFactoryImpl();
    private final boolean checkVersionCompatibility;
    private ContentVersionManager versionManager;

    public DefaultDiscoveryClient(Properties properties) {
        Objects.requireNonNull(properties, "Configuration properties are required!");
        String discoveryService = PropertyUtils.getStringProperty((Properties)properties, (String)"ServiceUri");
        Objects.requireNonNull(discoveryService, "Discovery service URI is required");
        this.properties = properties;
        this.checkVersionCompatibility = Boolean.valueOf(properties.getProperty("CheckVersionCompatibility"));
        if (this.checkVersionCompatibility) {
            this.versionManager = new ContentVersionManager(discoveryService, properties);
        }
    }

    @Override
    public Optional<TokenServiceCapability> getTokenServiceCapability() {
        return this.getCapability(TokenServiceCapability.class);
    }

    @Override
    public <T extends Capability> Optional<T> getCapability(Class<T> capabilityClazz, Optional<String> oAuthToken, String ... expandParameters) {
        Objects.requireNonNull(capabilityClazz, "Capability clazz is required!");
        List<T> capabilities = this.getCapabilities(capabilityClazz, oAuthToken, expandParameters);
        if (capabilities.size() == 0) {
            LOG.info("Capability: {} not found.", capabilityClazz);
        } else if (capabilities.size() > 1) {
            LOG.warn("More than one '{}' found.", capabilityClazz);
        }
        return capabilities.stream().findFirst();
    }

    @Override
    public <T extends ODataIdAwareEntity> Optional<T> getAwareEntity(Class<T> entityClazz, Optional<String> oAuthToken, String ... expandParameters) {
        Objects.requireNonNull(entityClazz, "ODataIdAwareEntity clazz is required!");
        List<T> entities = this.getAwareEntities(entityClazz, oAuthToken, expandParameters);
        if (entities.size() == 0) {
            LOG.warn("ODataIdAwareEntity: {} not found.", entityClazz);
        } else if (entities.size() > 1) {
            LOG.warn("More then one {} found.", entityClazz);
        }
        return entities.stream().findFirst();
    }

    @Override
    public <T extends ODataIdAwareEntity> List<T> getAwareEntities(Class<T> entityClazz, Optional<String> oAuthToken, String ... expandParameters) {
        Objects.requireNonNull(entityClazz, "Entity clazz is required!");
        LOG.trace("Trying to resolve: {}", entityClazz);
        return this.loadFromEndpointUrl(entityClazz, oAuthToken, expandParameters);
    }

    @Override
    public <T extends Capability> List<T> getCapabilities(Class<T> capabilityClazz, Optional<String> oAuthToken, String ... expandParameters) {
        Objects.requireNonNull(capabilityClazz, "Capability clazz is required!");
        LOG.trace("Trying to resolve: {}", capabilityClazz);
        return this.loadFromEndpointUrl(capabilityClazz, oAuthToken, expandParameters);
    }

    private <T> List<T> loadFromEndpointUrl(Class<T> resourceName, Optional<String> oAuthToken, String ... expandParameters) {
        String discoveryServiceUrl = ClientsUtil.makeEndWithoutSlash(PropertyUtils.getStringProperty((Properties)this.properties, (String)"ServiceUri"));
        LOG.trace("Preparing to send request to: {}", (Object)discoveryServiceUrl);
        CacheSecurityAwareClientPropertiesBuilder clientProperties = new CacheSecurityAwareClientPropertiesBuilder().withServiceUri(discoveryServiceUrl);
        Integer timeout = PropertyUtils.getIntegerProperty((Properties)this.properties, (String)"ConnectionTimeout");
        if (timeout != null) {
            clientProperties.withClientTimeout(timeout);
        }
        ODataV4ClientComponentsProvider oDataV4ClientComponentsProvider = new ODataV4ClientComponentsProvider(EDM_ENTITY_CLASSES, clientProperties.build());
        Map requestProperties = oAuthToken.isPresent() ? new URLConnectionRequestPropertiesBuilder().withAccessToken(oAuthToken.get()).build() : Collections.emptyMap();
        return this.doClientOperation(requestProperties, (ODataClientComponentsProvider)oDataV4ClientComponentsProvider, resourceName, expandParameters);
    }

    private <T> List<T> doClientOperation(Map<String, String> requestProperties, ODataClientComponentsProvider clientComponentsProvider, Class<T> resourceName, String ... expandParameters) {
        if (this.checkVersionCompatibility && !this.versionManager.isCompatible()) {
            LOG.debug("Discovery Client doesn't support Discovery Service {}", (Object)this.versionManager.getServiceVersion());
            throw new ODataClientRuntimeException("Unsupported version: " + this.versionManager.getServiceVersion());
        }
        ODataClient oDataClient = this.clientFactory.create(clientComponentsProvider);
        BasicODataClientQuery.Builder queryBuilder = new BasicODataClientQuery.Builder().withEntityType(resourceName);
        queryBuilder = this.addExpandParameters(queryBuilder, expandParameters);
        BasicODataClientQuery oDataClientQuery = queryBuilder.build();
        return oDataClient.getEntities(requestProperties, (ODataClientQuery)oDataClientQuery).stream().map(resourceName::cast).collect(Collectors.toList());
    }

    private BasicODataClientQuery.Builder addExpandParameters(BasicODataClientQuery.Builder queryBuilder, String ... expandParameters) {
        if (expandParameters != null && expandParameters.length > 0) {
            Arrays.asList(expandParameters).stream().forEach(s -> queryBuilder.withExpandParameters(s.trim()));
        }
        return queryBuilder;
    }

    @Override
    public String getServiceUrl() {
        return PropertyUtils.getStringProperty((Properties)this.properties, (String)"ServiceUri");
    }
}

