/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.sdl.odata.api.service.MediaType;
import com.sdl.odata.client.AbstractODataClientComponentsProvider;
import com.sdl.odata.client.api.caller.EndpointCaller;
import com.sdl.odata.client.api.exception.ODataClientException;
import com.sdl.odata.client.api.exception.ODataClientHttpError;
import com.sdl.odata.client.api.exception.ODataClientRuntimeException;
import com.sdl.web.client.ClientException;
import com.sdl.web.client.OAuthClient;
import com.sdl.web.client.impl.DefaultDiscoveryClient;
import com.sdl.web.client.impl.util.ClientsUtil;
import com.sdl.web.discovery.datalayer.model.TokenServiceCapability;
import com.sdl.web.oauth.common.DefaultOAuthToken;
import com.sdl.web.oauth.common.OAuthToken;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuthClient
implements OAuthClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOAuthClient.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final MapType MAP_TYPE = TypeFactory.defaultInstance().constructMapType(Map.class, String.class, String.class);
    private static final String ERROR_KEY = "error";
    private final Properties properties;
    private EndpointCaller endpointCaller;
    private String discoveryServiceUrl;
    private String tokenServiceUrl;

    DefaultOAuthClient(String tokenServiceUrl, Properties connectionProperties) {
        this.properties = connectionProperties;
        this.tokenServiceUrl = ClientsUtil.makeEndWithSlash(tokenServiceUrl);
    }

    public DefaultOAuthClient(Properties connectionProperties) {
        this.properties = connectionProperties;
        this.discoveryServiceUrl = connectionProperties.getProperty("ServiceUri");
        this.tokenServiceUrl = ClientsUtil.makeEndWithSlash(this.resolveTokenServiceUrl());
    }

    private EndpointCaller getEndpointCaller() {
        if (this.endpointCaller == null) {
            this.endpointCaller = AbstractODataClientComponentsProvider.initializeEndpointCaller((Properties)this.properties);
        }
        return this.endpointCaller;
    }

    @Override
    public OAuthToken getToken(String clientId, String clientSecret) throws ClientException {
        return this.doFetchOAuthToken(this.tokenServiceUrl, String.format("client_id=%s&client_secret=%s&grant_type=%s&resource=%s", clientId, clientSecret, "client_credentials", this.generateResourceQueryStringParameter()));
    }

    @Override
    public OAuthToken refreshToken(String clientId, OAuthToken token) throws ClientException {
        return this.doFetchOAuthToken(this.tokenServiceUrl, String.format("grant_type=%s&refresh_token=%s&client_id=%s&resource=%s", "refresh_token", token.getRefreshToken(), clientId, this.generateResourceQueryStringParameter()));
    }

    protected OAuthToken doFetchOAuthToken(String urlString, String requestBody) {
        String accessToken;
        URL url;
        try {
            LOG.debug("URL to be used: {}.", (Object)urlString);
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new ClientException("Could not to build valid OAuth URL.", e);
        }
        Map<String, String> result = this.obtainTokenResult(url, requestBody);
        try {
            accessToken = URLDecoder.decode(result.getOrDefault("access_token", ""), StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new ClientException("Could not decode access_token from OAuth response token.", e);
        }
        String refreshToken = result.getOrDefault("refresh_token", "");
        LOG.debug("Obtained a token: {}, refresh_token: {}.", (Object)accessToken, (Object)refreshToken);
        return new DefaultOAuthToken(accessToken, refreshToken);
    }

    private Map<String, String> obtainTokenResult(URL url, String requestBody) {
        Map result;
        String response;
        try {
            response = this.getEndpointCaller().doPostEntity(null, url, requestBody, MediaType.JSON, MediaType.JSON);
        }
        catch (ODataClientHttpError e) {
            throw e;
        }
        catch (ODataClientException | ODataClientRuntimeException e) {
            String exceptionMessage = "Unable to obtain OAuth token from discovery service. Probably Discovery service is not up and running.";
            if (e.getMessage().contains(ERROR_KEY)) {
                try {
                    exceptionMessage = (String)((Map)OBJECT_MAPPER.readValue(e.getMessage(), (JavaType)MAP_TYPE)).get(ERROR_KEY);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ClientException(exceptionMessage, e);
        }
        try {
            result = (Map)OBJECT_MAPPER.readValue(response, (JavaType)MAP_TYPE);
        }
        catch (IOException e) {
            LOG.error("Could not parse token response.", (Throwable)e);
            throw new ClientException("Could not parse token response.", e);
        }
        if (result.get(ERROR_KEY) != null) {
            throw new ClientException((String)result.get(ERROR_KEY));
        }
        return result;
    }

    private String generateResourceQueryStringParameter() throws ClientException {
        if (this.discoveryServiceUrl != null) {
            try {
                return URLEncoder.encode(this.discoveryServiceUrl, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new ClientException("Unable to URLEncode discovery service url: " + this.discoveryServiceUrl, e);
            }
        }
        return "";
    }

    private String resolveTokenServiceUrl() {
        DefaultDiscoveryClient discoveryClient = new DefaultDiscoveryClient(this.properties);
        Optional<TokenServiceCapability> tokenService = discoveryClient.getTokenServiceCapability();
        if (tokenService.isPresent()) {
            return tokenService.get().getUri();
        }
        LOG.info("Unable to locate token service capability. Will use discovery service location instead: {}", (Object)this.discoveryServiceUrl);
        return this.discoveryServiceUrl.replace("discovery.svc", "token.svc");
    }
}

