/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.impl;

import com.sdl.web.client.ClientException;
import com.sdl.web.client.EntityProvider;
import com.sdl.web.client.impl.CachingEntityProvider;
import com.sdl.web.client.impl.DefaultEntityProvider;
import com.sdl.web.client.impl.SecuredEntityProvider;
import java.util.Properties;

public class EntityProviderFactory {
    public static EntityProvider getCachingSecuredEntityProvider(Properties properties) throws ClientException {
        return new CachingEntityProvider(EntityProviderFactory.getSecuredEntityProvider(properties), properties);
    }

    public static EntityProvider getSecuredEntityProvider(Properties properties) {
        return new SecuredEntityProvider(properties);
    }

    public static EntityProvider getEntityProvider(Properties properties) {
        return new DefaultEntityProvider(properties);
    }

    public static EntityProvider getCachingDefaultEntityProvider(Properties properties) throws ClientException {
        return new CachingEntityProvider(EntityProviderFactory.getEntityProvider(properties), properties);
    }

    public static EntityProvider getEntityProvider(boolean secured, boolean cached, Properties properties) throws ClientException {
        if (secured && cached) {
            return EntityProviderFactory.getCachingSecuredEntityProvider(properties);
        }
        if (secured) {
            return EntityProviderFactory.getSecuredEntityProvider(properties);
        }
        if (cached) {
            return EntityProviderFactory.getCachingDefaultEntityProvider(properties);
        }
        return EntityProviderFactory.getEntityProvider(properties);
    }
}

