/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.impl;

import com.sdl.odata.client.property.PropertyUtils;
import com.sdl.web.client.ClientException;
import com.sdl.web.client.OAuthClient;
import com.sdl.web.client.impl.LegacyOAuthClient;
import com.sdl.web.client.impl.OAuthTokenProvider;
import com.sdl.web.oauth.common.OAuthToken;
import java.time.Instant;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyTokenProvider {
    private static final Object LOCK = new Object();
    private static final Logger LOG = LoggerFactory.getLogger(OAuthTokenProvider.class);
    private OAuthToken oAuthToken;
    private OAuthClient oAuthClient;
    private String clientId;
    private String clientSecret;

    protected LegacyTokenProvider(String tokenService, Properties properties) {
        this.initializeClientIdAndSecret(properties);
        this.oAuthClient = new LegacyOAuthClient(tokenService, properties);
    }

    public LegacyTokenProvider(Properties properties) {
        this.initializeClientIdAndSecret(properties);
        this.oAuthClient = new LegacyOAuthClient(properties);
    }

    private void initializeClientIdAndSecret(Properties properties) {
        this.clientId = PropertyUtils.getStringProperty((Properties)properties, (String)"ClientId");
        Objects.requireNonNull(this.clientId, "Client id is required!");
        this.clientSecret = PropertyUtils.getStringProperty((Properties)properties, (String)"ClientSecret");
        Objects.requireNonNull(this.clientSecret, "Client secret is required!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken() {
        if (this.isTokenExpired()) {
            Object object = LOCK;
            synchronized (object) {
                if (this.oAuthToken == null) {
                    LOG.debug("Initialising OAuth token");
                    this.oAuthToken = this.oAuthClient.getToken(this.clientId, this.clientSecret);
                } else if (this.isTokenExpired()) {
                    LOG.debug("OAuth token is expired, obtaining new one using refresh token.");
                    try {
                        this.oAuthToken = this.oAuthClient.refreshToken(this.clientId, this.oAuthToken);
                    }
                    catch (ClientException e) {
                        LOG.info("Obtaining token using refresh token not successful: {}. Trying to obtain new one using client id/secret.", (Object)e.getMessage());
                        this.oAuthToken = this.oAuthClient.getToken(this.clientId, this.clientSecret);
                    }
                }
            }
        }
        return this.oAuthToken.getToken();
    }

    public boolean isTokenExpired() {
        return this.oAuthToken == null || Instant.now().toEpochMilli() > this.oAuthToken.getExpiresOn();
    }
}

