/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.impl;

import com.sdl.web.client.CapabilityProvider;
import com.sdl.web.client.ClientException;
import com.sdl.web.client.DiscoveryClient;
import com.sdl.web.client.TokenProvider;
import com.sdl.web.client.TokenProviderClientException;
import com.sdl.web.client.configuration.TokenProviderFactory;
import com.sdl.web.client.impl.DefaultDiscoveryClient;
import com.sdl.web.discovery.datalayer.model.Capability;
import com.tridion.util.TridionReflectionException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

public class SecuredCapabilityProvider
implements CapabilityProvider {
    private final DiscoveryClient discoveryClient;
    private final TokenProvider tokenProvider;

    public SecuredCapabilityProvider(Properties properties) throws ClientException {
        Objects.requireNonNull(properties, "Configuration properties are required.");
        this.discoveryClient = new DefaultDiscoveryClient(properties);
        this.tokenProvider = this.createTokenProvider(properties);
    }

    private TokenProvider createTokenProvider(Properties properties) throws TokenProviderClientException {
        try {
            return TokenProviderFactory.getInstance().getDefaultTokenProvider(properties);
        }
        catch (TridionReflectionException e) {
            throw new TokenProviderClientException("Error initializing Token Provider.", e);
        }
    }

    @Override
    public <T extends Capability> Optional<T> getCapability(Class<T> capabilityClazz, String ... expandParameters) {
        return this.discoveryClient.getCapability(capabilityClazz, Optional.of(this.tokenProvider.getToken()), expandParameters);
    }
}

