/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.client.versions;

public class Version {
    public static final String NOT_VERSION = "not-version";
    private String[] version;

    public Version(String versionStr) {
        if (versionStr != null && !versionStr.equals(NOT_VERSION)) {
            this.version = versionStr.split("\\.");
        }
    }

    public String[] getVersion() {
        return this.version;
    }

    public String toString() {
        return this.version == null ? "" : String.join((CharSequence)".", this.version);
    }

    boolean isVersionInRangeOf(Version fromVersion, Version toVersion) {
        if (this.version == null) {
            return true;
        }
        boolean valid = true;
        if (fromVersion.getVersion() != null) {
            valid = Version.inOrder(fromVersion.getVersion(), this.version);
        }
        if (toVersion.getVersion() != null) {
            valid &= Version.inOrder(this.version, toVersion.getVersion());
        }
        return valid;
    }

    static boolean inOrder(String[] previousVersion, String[] nextVersion) {
        int length = Math.max(previousVersion.length, nextVersion.length);
        for (int i = 0; i < length; ++i) {
            int endValue;
            int startValue = i < previousVersion.length ? Integer.parseInt(previousVersion[i]) : 0;
            int n = endValue = i < nextVersion.length ? Integer.parseInt(nextVersion[i]) : 0;
            if (endValue < startValue) {
                return false;
            }
            if (endValue <= startValue) continue;
            return true;
        }
        return true;
    }
}

