/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.discovery.datalayer.model;

import com.sdl.odata.api.edm.annotations.EdmEntity;
import com.sdl.odata.api.edm.annotations.EdmEntitySet;
import com.sdl.odata.api.edm.annotations.EdmNavigationProperty;
import com.sdl.odata.api.edm.annotations.EdmProperty;
import com.sdl.odata.api.edm.model.OnDeleteAction;
import com.sdl.web.discovery.datalayer.annotations.ConfigArea;
import com.sdl.web.discovery.datalayer.annotations.ConfigItem;
import com.sdl.web.discovery.datalayer.annotations.ConfigValue;
import com.sdl.web.discovery.datalayer.annotations.UsedByConfig;
import com.sdl.web.discovery.datalayer.annotations.UsingConfig;
import com.sdl.web.discovery.datalayer.model.Capability;
import com.sdl.web.discovery.datalayer.model.DestinationURL;
import com.sdl.web.discovery.datalayer.model.EndpointStrategy;
import com.sdl.web.discovery.datalayer.model.Environment;
import com.sdl.web.discovery.datalayer.model.KeyValuePair;
import java.util.ArrayList;
import java.util.List;

@EdmEntity(namespace="Tridion.WebDelivery.Platform", key={"id"})
@EdmEntitySet(name="DeployerCapabilities", includedInServiceDocument=false)
@ConfigItem(area="Deployer")
public class DeployerCapability
implements Capability {
    @EdmProperty(nullable=false)
    @ConfigValue
    private String id;
    @EdmProperty(name="LastUpdateTime")
    @ConfigValue
    private Long lastUpdateTime;
    @EdmProperty
    @ConfigValue
    private String strategy = EndpointStrategy.DEFAULT.name();
    @EdmProperty(name="URI")
    @ConfigValue
    private String uri;
    @EdmProperty(name="URIs")
    @UsingConfig
    private List<DestinationURL> uris = new ArrayList<DestinationURL>();
    @EdmNavigationProperty(name="Environment", nullable=false, onDelete={OnDeleteAction.SET_NULL}, partner="DeployerCapability")
    @UsedByConfig(value="DeployerCapability")
    private Environment environment;
    @EdmProperty(name="ExtensionProperties", type="Collection(Tridion.WebDelivery.Platform.DeployerKeyValuePair)")
    @UsingConfig
    @ConfigArea(value="Deployer")
    private List<KeyValuePair> extensionProperties = new ArrayList<KeyValuePair>();

    public String getId() {
        return this.id;
    }

    public DeployerCapability setId(String newId) {
        this.id = newId;
        return this;
    }

    @Override
    public Long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public DeployerCapability setLastUpdateTime(Long newLastUpdateTime) {
        this.lastUpdateTime = newLastUpdateTime;
        return this;
    }

    public EndpointStrategy getStrategy() {
        return EndpointStrategy.valueOf(this.strategy);
    }

    public DeployerCapability setStrategy(EndpointStrategy newStrategy) {
        if (newStrategy != null) {
            this.strategy = newStrategy.name();
        }
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public DeployerCapability setUri(String newUri) {
        this.uri = newUri;
        return this;
    }

    public List<DestinationURL> getUris() {
        return this.uris;
    }

    public DeployerCapability setUris(List<DestinationURL> newUris) {
        this.uris = newUris;
        return this;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public DeployerCapability setEnvironment(Environment newEnvironment) {
        this.environment = newEnvironment;
        return this;
    }

    public List<KeyValuePair> getExtensionProperties() {
        return this.extensionProperties;
    }

    public DeployerCapability setExtensionProperties(List<KeyValuePair> newExtensionProperties) {
        this.extensionProperties = newExtensionProperties;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeployerCapability that = (DeployerCapability)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "DeployerCapability{id='" + this.id + '\'' + ", lastUpdateTime=" + this.lastUpdateTime + ", strategy='" + this.strategy + '\'' + ", uri='" + this.uri + '\'' + ", uris='" + this.uris + '\'' + ", ExtensionProperties='" + this.extensionProperties.toString() + '\'' + '}';
    }
}

