/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.discovery.datalayer.model;

import com.sdl.odata.api.ODataBadRequestException;
import com.sdl.odata.api.edm.annotations.EdmEntity;
import com.sdl.odata.api.edm.annotations.EdmEntitySet;
import com.sdl.odata.api.edm.annotations.EdmNavigationProperty;
import com.sdl.odata.api.edm.annotations.EdmProperty;
import com.sdl.odata.api.edm.model.OnDeleteAction;
import com.sdl.odata.client.api.model.ODataIdAwareEntity;
import com.sdl.web.discovery.datalayer.annotations.ConfigArea;
import com.sdl.web.discovery.datalayer.annotations.ConfigItem;
import com.sdl.web.discovery.datalayer.annotations.ConfigValue;
import com.sdl.web.discovery.datalayer.annotations.UsedByConfig;
import com.sdl.web.discovery.datalayer.annotations.UsingConfig;
import com.sdl.web.discovery.datalayer.model.BaseURL;
import com.sdl.web.discovery.datalayer.model.KeyValuePair;
import com.sdl.web.discovery.datalayer.model.PublicationMapping;
import com.sdl.web.discovery.datalayer.model.WebCapability;
import java.util.ArrayList;
import java.util.List;

@EdmEntity(namespace="Tridion.WebDelivery.Platform", key={"id"})
@EdmEntitySet(name="WebApplications")
@ConfigItem(area="Web")
public class WebApplication
implements ODataIdAwareEntity {
    @EdmProperty(nullable=false)
    @ConfigValue
    private String id;
    @EdmProperty(name="ContextURL", nullable=false)
    @ConfigValue
    private String contextUrl;
    @EdmNavigationProperty(name="WebCapability", nullable=false, onDelete={OnDeleteAction.NONE}, partner="WebApplications")
    @UsedByConfig(value="WebApplications")
    private WebCapability webCapability;
    @EdmProperty(name="BaseURLs", nullable=false)
    @UsingConfig
    private List<BaseURL> baseURLs = new ArrayList<BaseURL>();
    @EdmProperty(name="ExtensionProperties", nullable=true)
    @UsingConfig
    @ConfigArea(value="Web")
    private List<KeyValuePair> extensionProperties = new ArrayList<KeyValuePair>();
    @EdmNavigationProperty(name="PublicationMappings", nullable=true, onDelete={OnDeleteAction.CASCADE}, partner="WebApplications")
    @UsingConfig
    private List<PublicationMapping> publicationMappings = new ArrayList<PublicationMapping>();

    public String getId() {
        return this.id;
    }

    public WebApplication setId(String newId) {
        this.id = newId;
        return this;
    }

    public String getContextUrl() {
        return this.contextUrl;
    }

    public WebApplication setContextUrl(String newContextUrl) {
        this.contextUrl = newContextUrl;
        return this;
    }

    public WebCapability getWebCapability() {
        return this.webCapability;
    }

    public WebApplication setWebCapability(WebCapability newWebCapability) {
        this.webCapability = newWebCapability;
        return this;
    }

    public List<BaseURL> getBaseURLs() {
        return this.baseURLs;
    }

    public WebApplication setBaseURLs(List<BaseURL> newBaseURLs) {
        this.baseURLs = newBaseURLs;
        return this;
    }

    public List<PublicationMapping> getPublicationMappings() {
        return this.publicationMappings;
    }

    public WebApplication setPublicationMappings(List<PublicationMapping> newPublicationMappings) {
        this.publicationMappings = newPublicationMappings;
        return this;
    }

    public List<KeyValuePair> getExtensionProperties() {
        return this.extensionProperties;
    }

    public WebApplication setExtensionProperties(List<KeyValuePair> newExtensionProperties) {
        this.extensionProperties = newExtensionProperties;
        return this;
    }

    public WebApplication addExtensionProperty(KeyValuePair newExtensionProperty) throws ODataBadRequestException {
        for (KeyValuePair existingProperty : this.extensionProperties) {
            if (!newExtensionProperty.getKey().equals(existingProperty.getKey())) continue;
            throw new ODataBadRequestException("Extension Property with this key already exists");
        }
        this.extensionProperties.add(newExtensionProperty);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebApplication that = (WebApplication)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "WebApplication{id='" + this.id + '\'' + ", contextUrl='" + this.contextUrl + '\'' + '}';
    }
}

