/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.discovery.datalayer.model.actions;

import com.sdl.odata.api.ODataBadRequestException;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.annotations.EdmAction;
import com.sdl.odata.api.edm.annotations.EdmEntitySet;
import com.sdl.odata.api.edm.annotations.EdmReturnType;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.Operation;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.TargetType;
import com.sdl.odata.api.processor.datasource.DataSource;
import com.sdl.odata.api.processor.datasource.ODataDataSourceException;
import com.sdl.odata.api.processor.datasource.factory.DataSourceFactory;
import com.sdl.odata.api.processor.query.QueryOperation;
import com.sdl.odata.api.processor.query.SelectOperation;
import com.sdl.odata.api.processor.query.strategy.QueryOperationStrategy;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.parser.ODataUriParser;
import com.sdl.web.discovery.datalayer.model.Capability;
import com.sdl.web.discovery.datalayer.model.Environment;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;

@EdmAction(name="ResetServiceAction", namespace="Tridion.WebDelivery.Platform", isBound=false)
@EdmReturnType(type="Environment")
public class ResetServiceAction
implements Operation {
    private static final Logger LOG = LoggerFactory.getLogger(ResetServiceAction.class);
    private static final String ENVIRONMENT_ENTITY = "Environment";
    private static final String NAMESPACE = "Tridion.WebDelivery.Platform";

    public Object doOperation(ODataRequestContext requestContext, DataSourceFactory dataSourceFactory) throws ODataException {
        ODataUri oDataUri = requestContext.getUri();
        boolean isActionImportCall = ODataUriUtil.getActionImportCallName((ODataUri)oDataUri).isDefined();
        if (!isActionImportCall) {
            throw new ODataBadRequestException("The unbound action should be invoked via action import call");
        }
        SelectOperation operation = new SelectOperation(ENVIRONMENT_ENTITY, true);
        TargetType targetType = new TargetType("Tridion.WebDelivery.Platform.Environment", false, (Option)None$.MODULE$);
        QueryOperationStrategy strategy = dataSourceFactory.getStrategy(requestContext, (QueryOperation)operation, targetType);
        if (strategy == null) {
            throw new ODataDataSourceException("There is no strategy for entity: Environment");
        }
        List result = (List)strategy.execute().getData();
        if (result.size() < 1) {
            throw new ODataDataSourceException("There is no environment entity in database");
        }
        Environment environment = (Environment)result.get(0);
        DataSource dataSource = dataSourceFactory.getDataSource(requestContext, "Tridion.WebDelivery.Platform.Environment");
        EntityDataModel entityDataModel = requestContext.getEntityDataModel();
        this.deleteCapabilities(environment, entityDataModel, dataSource, oDataUri);
        return null;
    }

    private void deleteCapabilities(Environment environment, EntityDataModel entityDataModel, DataSource dataSource, ODataUri oDataUri) throws ODataException {
        ODataUriParser parser = new ODataUriParser(entityDataModel);
        List capabilityGetters = Stream.of(environment.getClass().getMethods()).filter(m -> Capability.class.isAssignableFrom(m.getReturnType())).collect(Collectors.toList());
        for (Method capabilityGetter : capabilityGetters) {
            Capability capability;
            EdmEntitySet edmEntitySetAnn;
            Object result = null;
            try {
                result = capabilityGetter.invoke((Object)environment, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.warn("Could not invoke method: " + capabilityGetter, (Throwable)e);
            }
            if (result == null || (edmEntitySetAnn = (capability = (Capability)result).getClass().getAnnotation(EdmEntitySet.class)) == null) continue;
            String capabilitySetName = edmEntitySetAnn.name();
            ODataUri capabilityUri = parser.parseUri(oDataUri.serviceRoot() + "/" + capabilitySetName + "('" + capability.getId() + "')");
            dataSource.delete(capabilityUri, entityDataModel);
        }
    }
}

