/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.discovery.datalayer.model.functions;

import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.annotations.EdmFunction;
import com.sdl.odata.api.edm.annotations.EdmReturnType;
import com.sdl.odata.api.edm.model.Operation;
import com.sdl.odata.api.processor.datasource.factory.DataSourceFactory;
import com.sdl.odata.api.service.ODataRequestContext;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

@EdmFunction(name="GetBuildVersionFunction", namespace="Tridion.WebDelivery.Platform", isBound=false)
@EdmReturnType(type="Edm.String")
public class GetBuildVersionFunction
implements Operation<String> {
    private static final String PROJECT_VERSION = "Implementation-Version";

    public String doOperation(ODataRequestContext requestContext, DataSourceFactory dataSourceFactory) throws ODataException {
        try {
            Manifest manifest;
            URL url = this.getClass().getProtectionDomain().getCodeSource().getLocation();
            if (url.getProtocol() != null && url.getProtocol().startsWith("vfs")) {
                VirtualFile virtualFile = VFS.getChild((URI)url.toURI());
                manifest = VFSUtils.getManifest((VirtualFile)virtualFile);
            } else {
                File file = new File(url.toURI());
                JarFile jarFile = new JarFile(file);
                manifest = jarFile.getManifest();
            }
            Attributes attributes = manifest.getMainAttributes();
            return attributes.getValue(PROJECT_VERSION);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

