/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.discovery.datalayer.model.actions;

import com.google.common.base.Preconditions;
import com.sdl.odata.api.ODataBadRequestException;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.annotations.EdmAction;
import com.sdl.odata.api.edm.annotations.EdmParameter;
import com.sdl.odata.api.edm.annotations.EdmReturnType;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.Operation;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.TargetType;
import com.sdl.odata.api.processor.datasource.DataSource;
import com.sdl.odata.api.processor.datasource.factory.DataSourceFactory;
import com.sdl.odata.api.processor.query.QueryOperation;
import com.sdl.odata.api.processor.query.QueryResult;
import com.sdl.odata.api.processor.query.SelectByKeyOperation;
import com.sdl.odata.api.processor.query.SelectOperation;
import com.sdl.odata.api.processor.query.strategy.QueryOperationStrategy;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.util.edm.EntityDataModelUtil;
import com.sdl.web.discovery.datalayer.model.KeyValuePair;
import com.sdl.web.discovery.datalayer.model.WebApplication;
import java.util.List;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;

@EdmAction(name="SetExtensionProperty", namespace="Tridion.WebDelivery.Platform", isBound=true)
@EdmReturnType(type="WebApplications")
public class SetExtensionProperty
implements Operation<WebApplication> {
    private static final String ID = "id";
    private static final String NAMESPACE = "Tridion.WebDelivery.Platform";
    private static final String ENTITY_TYPE = "WebApplication";
    @EdmParameter(name="Property", nullable=false)
    private String property;
    @EdmParameter(name="Value", nullable=false)
    private String value;

    public WebApplication doOperation(ODataRequestContext requestContext, DataSourceFactory dataSourceFactory) throws ODataException {
        ODataUri oDataUri = requestContext.getUri();
        Option entityName = ODataUriUtil.getBoundEntityName((ODataUri)oDataUri);
        if (!entityName.isDefined() || !((String)entityName.get()).equals(EntityDataModelUtil.pluralize((String)ENTITY_TYPE))) {
            throw new ODataBadRequestException("The action is invoked on incorrect entity");
        }
        EntityDataModel entityDataModel = requestContext.getEntityDataModel();
        Map keys = ODataUriUtil.getEntityKeyMap((ODataUri)oDataUri, (EntityDataModel)entityDataModel);
        String key = (String)Preconditions.checkNotNull((Object)keys.get((Object)ID).get());
        KeyValuePair keyValuePair = new KeyValuePair();
        keyValuePair.setKey(this.property);
        keyValuePair.setValue(this.value);
        SelectByKeyOperation operation = new SelectByKeyOperation((QueryOperation)new SelectOperation(EntityDataModelUtil.pluralize((String)ENTITY_TYPE), true), keys);
        TargetType targetType = new TargetType("Tridion.WebDelivery.Platform.WebApplication", false, Some.empty());
        QueryOperationStrategy strategy = dataSourceFactory.getStrategy(requestContext, (QueryOperation)operation, targetType);
        QueryResult result = strategy.execute();
        List resultList = (List)result.getData();
        if (resultList.size() > 1) {
            throw new ODataBadRequestException("There are more that one entity with key: " + key);
        }
        if (resultList.size() == 0) {
            throw new ODataBadRequestException("There are no entity with key: " + key);
        }
        WebApplication webApplication = (WebApplication)resultList.get(0);
        webApplication.addExtensionProperty(keyValuePair);
        DataSource dataSource = dataSourceFactory.getDataSource(requestContext, "Tridion.WebDelivery.Platform.WebApplication");
        dataSource.update(oDataUri, (Object)webApplication, entityDataModel);
        return webApplication;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

