/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.discovery.datalayer.model.functions;

import com.google.common.base.Preconditions;
import com.sdl.odata.api.ODataException;
import com.sdl.odata.api.edm.annotations.EdmFunction;
import com.sdl.odata.api.edm.annotations.EdmParameter;
import com.sdl.odata.api.edm.annotations.EdmReturnType;
import com.sdl.odata.api.edm.model.EntityDataModel;
import com.sdl.odata.api.edm.model.Operation;
import com.sdl.odata.api.parser.ODataUri;
import com.sdl.odata.api.parser.ODataUriUtil;
import com.sdl.odata.api.parser.TargetType;
import com.sdl.odata.api.processor.datasource.ODataDataSourceException;
import com.sdl.odata.api.processor.datasource.ODataQueryProcessingException;
import com.sdl.odata.api.processor.datasource.factory.DataSourceFactory;
import com.sdl.odata.api.processor.query.QueryOperation;
import com.sdl.odata.api.processor.query.QueryResult;
import com.sdl.odata.api.processor.query.SelectByKeyOperation;
import com.sdl.odata.api.processor.query.SelectOperation;
import com.sdl.odata.api.processor.query.strategy.QueryOperationStrategy;
import com.sdl.odata.api.service.ODataRequestContext;
import com.sdl.odata.util.edm.EntityDataModelUtil;
import com.sdl.web.discovery.datalayer.model.BaseURL;
import com.sdl.web.discovery.datalayer.model.KeyValuePair;
import com.sdl.web.discovery.datalayer.model.WebApplication;
import java.util.List;
import scala.Some;
import scala.collection.immutable.Map;

@EdmFunction(name="GetExtensionPropertyForHostFunction", namespace="Tridion.WebDelivery.Platform", isBound=true)
@EdmReturnType(type="Edm.String")
public class GetExtensionPropertyForHostFunction
implements Operation<String> {
    private static final String ENTITY_TYPE = "WebApplication";
    private static final String EDM_NAMESPACE = "Tridion.WebDelivery.Platform";
    @EdmParameter(name="property", nullable=false)
    private String property;
    @EdmParameter(name="host", nullable=false)
    private String host;

    public String doOperation(ODataRequestContext requestContext, DataSourceFactory dataSourceFactory) throws ODataException {
        TargetType targetType;
        Map keys = ODataUriUtil.getEntityKeyMap((ODataUri)requestContext.getUri(), (EntityDataModel)requestContext.getEntityDataModel());
        String key = (String)Preconditions.checkNotNull((Object)keys.get((Object)"id").get());
        SelectByKeyOperation operation = new SelectByKeyOperation((QueryOperation)new SelectOperation(EntityDataModelUtil.pluralize((String)ENTITY_TYPE), true), keys);
        QueryOperationStrategy strategy = dataSourceFactory.getStrategy(requestContext, (QueryOperation)operation, targetType = new TargetType("Tridion.WebDelivery.Platform.WebApplication", false, Some.empty()));
        if (strategy == null) {
            throw new ODataDataSourceException("There is no strategy found for SelectByKeyOperation operation and '" + targetType.typeName() + "' target type");
        }
        QueryResult result = strategy.execute();
        List resultList = (List)result.getData();
        if (resultList.size() > 1) {
            throw new ODataQueryProcessingException("There are more that one entity with key: " + key);
        }
        if (resultList.size() == 0) {
            throw new ODataDataSourceException("There are no entity with key: " + key);
        }
        WebApplication webApplication = (WebApplication)resultList.get(0);
        for (BaseURL baseURL : webApplication.getBaseURLs()) {
            if (!baseURL.getHost().equals(this.getHost())) continue;
            for (KeyValuePair webKeyValuePair : webApplication.getExtensionProperties()) {
                if (!webKeyValuePair.getKey().equals(this.property)) continue;
                return webKeyValuePair.getValue();
            }
        }
        return null;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

