/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.discovery.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.nustaq.serialization.FSTConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SerializeUtils.class);
    private static final FSTConfiguration FST = FSTConfiguration.createDefaultConfiguration();

    private SerializeUtils() {
    }

    public static byte[] serialize(Serializable obj, int compressThreshold) {
        byte[] bytes = FST.asByteArray((Object)obj);
        return SerializeUtils.compressWithExtraByte(bytes, compressThreshold);
    }

    private static byte[] compressWithExtraByte(byte[] data, int compressThreshold) {
        byte[] resultData;
        if (data.length > compressThreshold) {
            byte[] compressedData = SerializeUtils.compressSerializedData(data);
            resultData = new byte[compressedData.length + 1];
            System.arraycopy(compressedData, 0, resultData, 0, compressedData.length);
            resultData[resultData.length - 1] = 1;
        } else {
            resultData = new byte[data.length + 1];
            System.arraycopy(data, 0, resultData, 0, data.length);
            resultData[resultData.length - 1] = 0;
        }
        return resultData;
    }

    private static byte[] decompressDroppingExtraByte(byte[] data) {
        byte[] resultData;
        byte compressionFlag = data[data.length - 1];
        if (compressionFlag == 1) {
            resultData = new byte[data.length - 1];
            System.arraycopy(data, 0, resultData, 0, data.length - 1);
            resultData = SerializeUtils.deCompress(resultData);
        } else if (compressionFlag == 0) {
            resultData = new byte[data.length - 1];
            System.arraycopy(data, 0, resultData, 0, data.length - 1);
        } else {
            throw new IllegalStateException("Last extra byte should be either 1 or 0, but is: " + compressionFlag);
        }
        return resultData;
    }

    private static byte[] compressSerializedData(byte[] data) {
        LOG.debug("Compressing data of size {}", (Object)data.length);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (CompressorOutputStream gzippedOut = new CompressorStreamFactory().createCompressorOutputStream("gz", (OutputStream)bos);){
            LOG.debug("Writing Gzipped content to output stream.");
            gzippedOut.write(data);
            LOG.debug("Completed writing Gzipped content to output stream.");
        }
        catch (IOException | CompressorException e) {
            LOG.warn("Error when trying to compress data of length {}. Returning without compression.", (Object)data.length, (Object)e);
            return data;
        }
        byte[] compressedBytes = bos.toByteArray();
        LOG.debug("Size of Gzip compressed encoded data is {}.", (Object)compressedBytes.length);
        return compressedBytes;
    }

    private static byte[] deCompress(byte[] data) {
        byte[] bytes;
        LOG.debug("Decompressing cached data.");
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
             GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)inputStream);){
            LOG.debug("Writing Gzip InputStream to byteArray");
            bytes = IOUtils.toByteArray((InputStream)gzIn);
            LOG.debug("Completed writing Gzip InputStream to byteArray");
        }
        catch (IOException e) {
            LOG.error("Error when deCompressing cached data", (Throwable)e);
            return data;
        }
        return bytes;
    }

    public static <T> T deserialize(byte[] objectData) {
        if (objectData == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        return (T)FST.asObject(SerializeUtils.decompressDroppingExtraByte(objectData));
    }
}

