/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.ugc.odata.claimprocessor;

import com.sdl.web.ugc.odata.claimprocessor.BasePostClaimProcessor;
import com.tridion.ambientdata.AmbientDataException;
import com.tridion.ambientdata.claimstore.ClaimStore;
import com.tridion.ambientdata.processing.ClaimProcessor;
import com.tridion.ambientdata.web.WebClaims;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllowAnonymousPostClaimProcessor
implements ClaimProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AllowAnonymousPostClaimProcessor.class);

    public void onRequestStart(ClaimStore claimStore) throws AmbientDataException {
        if (!claimStore.contains(BasePostClaimProcessor.USER_CLAIM)) {
            String trackingId = "";
            Object headers = claimStore.get(WebClaims.REQUEST_HEADERS);
            if (headers != null) {
                Map map = (Map)headers;
                if (map.containsKey(BasePostClaimProcessor.HEADER_USER_ID.toString())) {
                    String[] userId = (String[])map.get(BasePostClaimProcessor.HEADER_USER_ID.toString());
                    trackingId = userId[0];
                    LOG.debug("Ugc UserId [" + trackingId + "]");
                } else {
                    LOG.debug("No external user specified, using tracking id.");
                    trackingId = (String)claimStore.get(WebClaims.TRACKING_ID);
                }
            } else {
                LOG.debug("No external user specified, using tracking id.");
                trackingId = (String)claimStore.get(WebClaims.TRACKING_ID);
            }
            claimStore.put(BasePostClaimProcessor.USER_CLAIM, (Object)trackingId);
        }
    }

    public void onRequestEnd(ClaimStore claimStore) throws AmbientDataException {
    }

    public void onSessionStart(ClaimStore claimStore) throws AmbientDataException {
    }
}

