/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.ugc.odata.claimprocessor;

import com.sdl.web.content.odata.configuration.ApplicationContextProvider;
import com.sdl.web.content.odata.input.ODataInputElement;
import com.sdl.web.content.odata.input.ODataInputParser;
import com.sdl.web.content.odata.input.handler.ODataWebHandler;
import com.sdl.web.ugc.odata.resolver.ResolverTypes;
import com.tridion.ambientdata.claimstore.ClaimStore;
import com.tridion.ambientdata.processing.ClaimProcessor;
import com.tridion.ambientdata.web.WebClaims;
import com.tridion.webservices.QueryException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePostClaimProcessor
implements ClaimProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(BasePostClaimProcessor.class);
    public static final URI USER_CLAIM = URI.create("taf:claim:contentdelivery:webservice:user");
    public static final URI HEADER_USER_ID = URI.create("x-ugc-userid");
    private static final String OPERATION_NAME = "CommentScoreIncrement";
    private ODataInputParser oDataInputParser;

    public void onSessionStart(ClaimStore claimStore) {
    }

    public void onRequestStart(ClaimStore claimStore) {
        String requestURI = (String)claimStore.get(WebClaims.REQUEST_URI);
        if (ODataWebHandler.getOdataSvcPrefix() != null && requestURI.contains(ODataWebHandler.getOdataSvcPrefix())) {
            String oDataQuery = requestURI.substring(requestURI.indexOf(ODataWebHandler.getOdataSvcPrefix()) + ODataWebHandler.getOdataSvcPrefix().length());
            try {
                ODataInputElement element;
                if (this.oDataInputParser == null) {
                    this.oDataInputParser = (ODataInputParser)ApplicationContextProvider.getApplicationContext().getBean(ODataInputParser.class);
                }
                if ((element = this.oDataInputParser.parse(oDataQuery)) != null) {
                    if (ResolverTypes.RATINGS.equals(element.getType()) || ResolverTypes.COMMENTS.equals(element.getType()) || ResolverTypes.USERS.equals(element.getType()) || ResolverTypes.ITEM_STATS.equals(element.getType())) {
                        if (claimStore.contains(USER_CLAIM)) {
                            String userId = (String)claimStore.get(USER_CLAIM, String.class);
                            LOG.trace("User ID: {}, Request URI: {}", (Object)userId, (Object)requestURI);
                            this.verifyIfPostIsAllowed(claimStore, element, userId);
                        } else {
                            LOG.debug("No user claim set, not allowing request.");
                        }
                    }
                } else {
                    LOG.debug("Not allowing post on the root!");
                }
            }
            catch (QueryException e) {
                if (oDataQuery.contains(OPERATION_NAME) || oDataQuery.contains(OPERATION_NAME)) {
                    LOG.debug("Allowing access to service operation: {}", (Object)oDataQuery);
                    claimStore.put(ODataWebHandler.POST_ALLOWED_CLAIM, (Object)true);
                }
                LOG.debug("Doesn't concern UGC.");
            }
        }
    }

    public void onRequestEnd(ClaimStore claimStore) {
    }

    protected abstract void verifyIfPostIsAllowed(ClaimStore var1, ODataInputElement var2, String var3);

    protected void setoDataInputParser(ODataInputParser oDataInputParser) {
        this.oDataInputParser = oDataInputParser;
    }
}

