/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.ugc.odata.claimprocessor;

import com.sdl.web.content.odata.input.ODataInputElement;
import com.sdl.web.content.odata.input.handler.ODataWebHandler;
import com.sdl.web.ugc.UGCTypeMapping;
import com.sdl.web.ugc.odata.claimprocessor.BasePostClaimProcessor;
import com.sdl.web.ugc.odata.resolver.ResolverTypes;
import com.tridion.ambientdata.claimstore.ClaimStore;
import com.tridion.ambientdata.web.WebClaims;
import com.tridion.broker.StorageException;
import com.tridion.storage.StorageManagerFactory;
import com.tridion.storage.ugc.UGCComment;
import com.tridion.storage.ugc.UGCRating;
import com.tridion.storage.ugc.dao.CommentDAO;
import com.tridion.storage.ugc.dao.RatingDAO;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostAllowedByOwnerClaimProcessor
extends BasePostClaimProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(PostAllowedByOwnerClaimProcessor.class);

    @Override
    protected void verifyIfPostIsAllowed(ClaimStore claimStore, ODataInputElement element, String userId) {
        block11: {
            Map serverVariables = (Map)claimStore.get(WebClaims.SERVER_VARIABLES);
            if ("POST".equals(serverVariables.get("REQUEST_METHOD"))) {
                LOG.trace("This is a POST, setting post_allowed_claim to true");
                claimStore.put(ODataWebHandler.POST_ALLOWED_CLAIM, (Object)true);
            } else if ("PUT".equals(serverVariables.get("REQUEST_METHOD")) || "DELETE".equals(serverVariables.get("REQUEST_METHOD"))) {
                try {
                    LOG.trace("This is a PUT or DELETE, checking if this is the owner");
                    if (ResolverTypes.RATINGS.equals(element.getType())) {
                        long ratingId = Long.parseLong(element.getIdentifier("Id"));
                        if (PostAllowedByOwnerClaimProcessor.isRatingOwner(ratingId, userId)) {
                            LOG.trace("This is the owner of the rating, setting post_allowed_claim to true");
                            claimStore.put(ODataWebHandler.POST_ALLOWED_CLAIM, (Object)true);
                        } else {
                            LOG.trace("This is not the owner of the rating, setting post_allowed_claim to false");
                            claimStore.put(ODataWebHandler.POST_ALLOWED_CLAIM, (Object)false);
                        }
                        break block11;
                    }
                    if (!ResolverTypes.COMMENTS.equals(element.getType())) break block11;
                    long commentId = Long.parseLong(element.getIdentifier("Id"));
                    if (PostAllowedByOwnerClaimProcessor.isCommentOwner(commentId, userId)) {
                        LOG.trace("This is the owner of the comment, setting post_allowed_claim to true");
                        claimStore.put(ODataWebHandler.POST_ALLOWED_CLAIM, (Object)true);
                        break block11;
                    }
                    LOG.trace("This is not the owner of the comment, setting post_allowed_claim to false");
                    claimStore.put(ODataWebHandler.POST_ALLOWED_CLAIM, (Object)false);
                }
                catch (StorageException e) {
                    LOG.error("Could not find the involved entity.", (Throwable)e);
                }
                catch (NumberFormatException e) {
                    LOG.error("Unable to parse Id.", (Throwable)e);
                }
            } else {
                LOG.trace("This is a GET request, setting post_allowed_claim to false");
                claimStore.put(ODataWebHandler.POST_ALLOWED_CLAIM, (Object)false);
            }
        }
    }

    private static boolean isRatingOwner(long ratingId, String userId) throws StorageException {
        RatingDAO ratingDAO = (RatingDAO)StorageManagerFactory.getDefaultDAO((String)UGCTypeMapping.RATING.getConfigurationName());
        UGCRating rating = ratingDAO.findByPrimaryKey(ratingId);
        return rating.getUser().getId().equals(userId);
    }

    private static boolean isCommentOwner(long commentId, String userId) throws StorageException {
        CommentDAO commentDAO = (CommentDAO)StorageManagerFactory.getDefaultDAO((String)UGCTypeMapping.COMMENT.getConfigurationName());
        UGCComment comment = commentDAO.findByPrimaryKey(commentId);
        return comment.getUser().getId().equals(userId);
    }
}

