/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.ugc.validation;

import com.sdl.web.ugc.validation.ValidationException;
import com.sdl.web.ugc.validation.ValidationFacade;
import com.tridion.configuration.Configuration;
import com.tridion.configuration.ConfigurationException;
import com.tridion.configuration.XMLConfigurationReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UGCValidationFacade {
    private static final Logger LOG = LoggerFactory.getLogger(UGCValidationFacade.class);
    private static final String UGC_CONFIG_FILENAME = "cd_ugc_conf.xml";
    private static final String UGC_SCHEMA_FILENAME = "schemas/cd_ugc_conf.xsd";
    private static ValidationFacade validationFacade;

    private static void initializeValidationFacade() {
        validationFacade = new ValidationFacade();
        XMLConfigurationReader configurationReader = new XMLConfigurationReader();
        try {
            Configuration loadedConfiguration = configurationReader.readConfiguration(UGC_CONFIG_FILENAME, UGC_SCHEMA_FILENAME);
            Configuration contentValidatorsConf = loadedConfiguration.getChild("ContentValidators");
            validationFacade.configure(contentValidatorsConf);
        }
        catch (ConfigurationException e) {
            LOG.warn("No UGC configuration present or configuration malformed.", (Object)e.getMessage());
        }
    }

    public static void validate(Object itemToValidate) throws ValidationException {
        validationFacade.validate(itemToValidate);
    }

    static {
        UGCValidationFacade.initializeValidationFacade();
    }
}

