/*
 * Decompiled with CFR 0.152.
 */
package com.sdl.web.ugc.validation;

import com.sdl.web.ugc.validation.ContentValidator;
import com.sdl.web.ugc.validation.ValidationException;
import com.sdl.web.ugc.validation.adaptors.ContentValidatorSpringAdapter;
import com.tridion.configuration.Configurable;
import com.tridion.configuration.Configuration;
import com.tridion.configuration.ConfigurationException;
import com.tridion.util.ReflectionUtil;
import com.tridion.util.TridionReflectionException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public class ValidationFacade
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationFacade.class);
    private ArrayList<ContentValidator> configuredValidators = new ArrayList();

    public void configure(Configuration configuration) {
        List validators = configuration.getChildrenByName("ContentValidator");
        for (Configuration conf : validators) {
            try {
                String implClass = conf.getAttribute("Implementation");
                ContentValidator validator = (ContentValidator)ReflectionUtil.loadClassInstance((String)implClass, ContentValidator.class, (Object[])new Object[0]);
                validator.configure(conf);
                this.configuredValidators.add(validator);
            }
            catch (ConfigurationException e) {
                LOG.warn("ContentValidator configuration malformed!", (Object)e.getMessage());
            }
            catch (TridionReflectionException e) {
                LOG.warn("ContentValidator class could not be loaded! A missing jar?", (Object)e.getMessage());
            }
        }
    }

    public void validate(Object itemToValidate) throws ValidationException {
        BindException errors = new BindException(itemToValidate, itemToValidate.getClass().getName());
        for (ContentValidator v : this.configuredValidators) {
            ContentValidatorSpringAdapter validator = new ContentValidatorSpringAdapter(v);
            if (!validator.supports(itemToValidate.getClass())) continue;
            ValidationUtils.invokeValidator((Validator)validator, (Object)itemToValidate, (Errors)errors);
        }
        if (errors.hasErrors()) {
            throw new ValidationException(this.constructErrorMessage((Errors)errors));
        }
    }

    private String constructErrorMessage(Errors errors) {
        StringBuilder errorMessage = new StringBuilder();
        boolean firstError = true;
        for (ObjectError error : errors.getAllErrors()) {
            if (!firstError) {
                errorMessage.append(", ");
            } else {
                firstError = false;
            }
            errorMessage.append(error.getDefaultMessage());
        }
        return errorMessage.toString();
    }
}

